/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the metadata of the user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserMetadata implements SdkPojo, Serializable, ToCopyableBuilder<UserMetadata.Builder, UserMetadata> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UserMetadata::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(UserMetadata::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> GIVEN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GivenName").getter(getter(UserMetadata::givenName)).setter(setter(Builder::givenName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GivenName").build()).build();

    private static final SdkField<String> SURNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Surname")
            .getter(getter(UserMetadata::surname)).setter(setter(Builder::surname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Surname").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(UserMetadata::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, USERNAME_FIELD,
            GIVEN_NAME_FIELD, SURNAME_FIELD, EMAIL_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String username;

    private final String givenName;

    private final String surname;

    private final String emailAddress;

    private UserMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.username = builder.username;
        this.givenName = builder.givenName;
        this.surname = builder.surname;
        this.emailAddress = builder.emailAddress;
    }

    /**
     * <p>
     * The ID of the user.
     * </p>
     * 
     * @return The ID of the user.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @return The name of the user.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The given name of the user before a rename operation.
     * </p>
     * 
     * @return The given name of the user before a rename operation.
     */
    public final String givenName() {
        return givenName;
    }

    /**
     * <p>
     * The surname of the user.
     * </p>
     * 
     * @return The surname of the user.
     */
    public final String surname() {
        return surname;
    }

    /**
     * <p>
     * The email address of the user.
     * </p>
     * 
     * @return The email address of the user.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(givenName());
        hashCode = 31 * hashCode + Objects.hashCode(surname());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserMetadata)) {
            return false;
        }
        UserMetadata other = (UserMetadata) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(username(), other.username())
                && Objects.equals(givenName(), other.givenName()) && Objects.equals(surname(), other.surname())
                && Objects.equals(emailAddress(), other.emailAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserMetadata").add("Id", id())
                .add("Username", username() == null ? null : "*** Sensitive Data Redacted ***")
                .add("GivenName", givenName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Surname", surname() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "GivenName":
            return Optional.ofNullable(clazz.cast(givenName()));
        case "Surname":
            return Optional.ofNullable(clazz.cast(surname()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserMetadata, T> g) {
        return obj -> g.apply((UserMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserMetadata> {
        /**
         * <p>
         * The ID of the user.
         * </p>
         * 
         * @param id
         *        The ID of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the user.
         * </p>
         * 
         * @param username
         *        The name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The given name of the user before a rename operation.
         * </p>
         * 
         * @param givenName
         *        The given name of the user before a rename operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder givenName(String givenName);

        /**
         * <p>
         * The surname of the user.
         * </p>
         * 
         * @param surname
         *        The surname of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder surname(String surname);

        /**
         * <p>
         * The email address of the user.
         * </p>
         * 
         * @param emailAddress
         *        The email address of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String username;

        private String givenName;

        private String surname;

        private String emailAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(UserMetadata model) {
            id(model.id);
            username(model.username);
            givenName(model.givenName);
            surname(model.surname);
            emailAddress(model.emailAddress);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getGivenName() {
            return givenName;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final String getSurname() {
            return surname;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public UserMetadata build() {
            return new UserMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
