/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.BooleanEnumType;
import software.amazon.awssdk.services.workdocs.model.LocaleType;
import software.amazon.awssdk.services.workdocs.model.StorageRuleType;
import software.amazon.awssdk.services.workdocs.model.UserType;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, UpdateUserRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationToken").getter(UpdateUserRequest.getter(UpdateUserRequest::authenticationToken)).setter(UpdateUserRequest.setter(Builder::authenticationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(UpdateUserRequest.getter(UpdateUserRequest::userId)).setter(UpdateUserRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("UserId").build()}).build();
    private static final SdkField<String> GIVEN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GivenName").getter(UpdateUserRequest.getter(UpdateUserRequest::givenName)).setter(UpdateUserRequest.setter(Builder::givenName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GivenName").build()}).build();
    private static final SdkField<String> SURNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Surname").getter(UpdateUserRequest.getter(UpdateUserRequest::surname)).setter(UpdateUserRequest.setter(Builder::surname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Surname").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(UpdateUserRequest.getter(UpdateUserRequest::typeAsString)).setter(UpdateUserRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<StorageRuleType> STORAGE_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StorageRule").getter(UpdateUserRequest.getter(UpdateUserRequest::storageRule)).setter(UpdateUserRequest.setter(Builder::storageRule)).constructor(StorageRuleType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageRule").build()}).build();
    private static final SdkField<String> TIME_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeZoneId").getter(UpdateUserRequest.getter(UpdateUserRequest::timeZoneId)).setter(UpdateUserRequest.setter(Builder::timeZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZoneId").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Locale").getter(UpdateUserRequest.getter(UpdateUserRequest::localeAsString)).setter(UpdateUserRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()}).build();
    private static final SdkField<String> GRANT_POWERUSER_PRIVILEGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantPoweruserPrivileges").getter(UpdateUserRequest.getter(UpdateUserRequest::grantPoweruserPrivilegesAsString)).setter(UpdateUserRequest.setter(Builder::grantPoweruserPrivileges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantPoweruserPrivileges").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD, USER_ID_FIELD, GIVEN_NAME_FIELD, SURNAME_FIELD, TYPE_FIELD, STORAGE_RULE_FIELD, TIME_ZONE_ID_FIELD, LOCALE_FIELD, GRANT_POWERUSER_PRIVILEGES_FIELD));
    private final String authenticationToken;
    private final String userId;
    private final String givenName;
    private final String surname;
    private final String type;
    private final StorageRuleType storageRule;
    private final String timeZoneId;
    private final String locale;
    private final String grantPoweruserPrivileges;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.userId = builder.userId;
        this.givenName = builder.givenName;
        this.surname = builder.surname;
        this.type = builder.type;
        this.storageRule = builder.storageRule;
        this.timeZoneId = builder.timeZoneId;
        this.locale = builder.locale;
        this.grantPoweruserPrivileges = builder.grantPoweruserPrivileges;
    }

    public final String authenticationToken() {
        return this.authenticationToken;
    }

    public final String userId() {
        return this.userId;
    }

    public final String givenName() {
        return this.givenName;
    }

    public final String surname() {
        return this.surname;
    }

    public final UserType type() {
        return UserType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final StorageRuleType storageRule() {
        return this.storageRule;
    }

    public final String timeZoneId() {
        return this.timeZoneId;
    }

    public final LocaleType locale() {
        return LocaleType.fromValue(this.locale);
    }

    public final String localeAsString() {
        return this.locale;
    }

    public final BooleanEnumType grantPoweruserPrivileges() {
        return BooleanEnumType.fromValue(this.grantPoweruserPrivileges);
    }

    public final String grantPoweruserPrivilegesAsString() {
        return this.grantPoweruserPrivileges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.givenName());
        hashCode = 31 * hashCode + Objects.hashCode(this.surname());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantPoweruserPrivilegesAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.givenName(), other.givenName()) && Objects.equals(this.surname(), other.surname()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.storageRule(), other.storageRule()) && Objects.equals(this.timeZoneId(), other.timeZoneId()) && Objects.equals(this.localeAsString(), other.localeAsString()) && Objects.equals(this.grantPoweruserPrivilegesAsString(), other.grantPoweruserPrivilegesAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserRequest").add("AuthenticationToken", (Object)(this.authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")).add("UserId", (Object)this.userId()).add("GivenName", (Object)(this.givenName() == null ? null : "*** Sensitive Data Redacted ***")).add("Surname", (Object)(this.surname() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("StorageRule", (Object)this.storageRule()).add("TimeZoneId", (Object)this.timeZoneId()).add("Locale", (Object)this.localeAsString()).add("GrantPoweruserPrivileges", (Object)this.grantPoweruserPrivilegesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "GivenName": {
                return Optional.ofNullable(clazz.cast(this.givenName()));
            }
            case "Surname": {
                return Optional.ofNullable(clazz.cast(this.surname()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "StorageRule": {
                return Optional.ofNullable(clazz.cast(this.storageRule()));
            }
            case "TimeZoneId": {
                return Optional.ofNullable(clazz.cast(this.timeZoneId()));
            }
            case "Locale": {
                return Optional.ofNullable(clazz.cast(this.localeAsString()));
            }
            case "GrantPoweruserPrivileges": {
                return Optional.ofNullable(clazz.cast(this.grantPoweruserPrivilegesAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String userId;
        private String givenName;
        private String surname;
        private String type;
        private StorageRuleType storageRule;
        private String timeZoneId;
        private String locale;
        private String grantPoweruserPrivileges;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.userId(model.userId);
            this.givenName(model.givenName);
            this.surname(model.surname);
            this.type(model.type);
            this.storageRule(model.storageRule);
            this.timeZoneId(model.timeZoneId);
            this.locale(model.locale);
            this.grantPoweruserPrivileges(model.grantPoweruserPrivileges);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getGivenName() {
            return this.givenName;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final String getSurname() {
            return this.surname;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final StorageRuleType.Builder getStorageRule() {
            return this.storageRule != null ? this.storageRule.toBuilder() : null;
        }

        public final void setStorageRule(StorageRuleType.BuilderImpl storageRule) {
            this.storageRule = storageRule != null ? storageRule.build() : null;
        }

        @Override
        public final Builder storageRule(StorageRuleType storageRule) {
            this.storageRule = storageRule;
            return this;
        }

        public final String getTimeZoneId() {
            return this.timeZoneId;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(LocaleType locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final String getGrantPoweruserPrivileges() {
            return this.grantPoweruserPrivileges;
        }

        public final void setGrantPoweruserPrivileges(String grantPoweruserPrivileges) {
            this.grantPoweruserPrivileges = grantPoweruserPrivileges;
        }

        @Override
        public final Builder grantPoweruserPrivileges(String grantPoweruserPrivileges) {
            this.grantPoweruserPrivileges = grantPoweruserPrivileges;
            return this;
        }

        @Override
        public final Builder grantPoweruserPrivileges(BooleanEnumType grantPoweruserPrivileges) {
            this.grantPoweruserPrivileges(grantPoweruserPrivileges == null ? null : grantPoweruserPrivileges.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserRequest> {
        public Builder authenticationToken(String var1);

        public Builder userId(String var1);

        public Builder givenName(String var1);

        public Builder surname(String var1);

        public Builder type(String var1);

        public Builder type(UserType var1);

        public Builder storageRule(StorageRuleType var1);

        default public Builder storageRule(Consumer<StorageRuleType.Builder> storageRule) {
            return this.storageRule((StorageRuleType)((StorageRuleType.Builder)StorageRuleType.builder().applyMutation(storageRule)).build());
        }

        public Builder timeZoneId(String var1);

        public Builder locale(String var1);

        public Builder locale(LocaleType var1);

        public Builder grantPoweruserPrivileges(String var1);

        public Builder grantPoweruserPrivileges(BooleanEnumType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

