/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CommentStatusType {
    DRAFT("DRAFT"),
    PUBLISHED("PUBLISHED"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CommentStatusType> VALUE_MAP;
    private final String value;

    private CommentStatusType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CommentStatusType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CommentStatusType> knownValues() {
        EnumSet<CommentStatusType> knownValues = EnumSet.allOf(CommentStatusType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CommentStatusType.class, CommentStatusType::toString);
    }
}

