/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LocaleType {
    EN("en"),
    FR("fr"),
    KO("ko"),
    DE("de"),
    ES("es"),
    JA("ja"),
    RU("ru"),
    ZH_CN("zh_CN"),
    ZH_TW("zh_TW"),
    PT_BR("pt_BR"),
    DEFAULT("default"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LocaleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LocaleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LocaleType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LocaleType> knownValues() {
        return Stream.of(LocaleType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

