/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadataListCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDocumentVersionsResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, DescribeDocumentVersionsResponse> {
    private static final SdkField<List<DocumentVersionMetadata>> DOCUMENT_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentVersions").getter(DescribeDocumentVersionsResponse.getter(DescribeDocumentVersionsResponse::documentVersions)).setter(DescribeDocumentVersionsResponse.setter(Builder::documentVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentVersionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDocumentVersionsResponse.getter(DescribeDocumentVersionsResponse::marker)).setter(DescribeDocumentVersionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_VERSIONS_FIELD, MARKER_FIELD));
    private final List<DocumentVersionMetadata> documentVersions;
    private final String marker;

    private DescribeDocumentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.documentVersions = builder.documentVersions;
        this.marker = builder.marker;
    }

    public final boolean hasDocumentVersions() {
        return this.documentVersions != null && !(this.documentVersions instanceof SdkAutoConstructList);
    }

    public final List<DocumentVersionMetadata> documentVersions() {
        return this.documentVersions;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentVersions() ? this.documentVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentVersionsResponse)) {
            return false;
        }
        DescribeDocumentVersionsResponse other = (DescribeDocumentVersionsResponse)((Object)obj);
        return this.hasDocumentVersions() == other.hasDocumentVersions() && Objects.equals(this.documentVersions(), other.documentVersions()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDocumentVersionsResponse").add("DocumentVersions", this.hasDocumentVersions() ? this.documentVersions() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentVersions": {
                return Optional.ofNullable(clazz.cast(this.documentVersions()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDocumentVersionsResponse, T> g) {
        return obj -> g.apply((DescribeDocumentVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private List<DocumentVersionMetadata> documentVersions = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentVersionsResponse model) {
            super(model);
            this.documentVersions(model.documentVersions);
            this.marker(model.marker);
        }

        public final List<DocumentVersionMetadata.Builder> getDocumentVersions() {
            List<DocumentVersionMetadata.Builder> result = DocumentVersionMetadataListCopier.copyToBuilder(this.documentVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder documentVersions(Collection<DocumentVersionMetadata> documentVersions) {
            this.documentVersions = DocumentVersionMetadataListCopier.copy(documentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentVersions(DocumentVersionMetadata ... documentVersions) {
            this.documentVersions(Arrays.asList(documentVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentVersions(Consumer<DocumentVersionMetadata.Builder> ... documentVersions) {
            this.documentVersions(Stream.of(documentVersions).map(c -> (DocumentVersionMetadata)((DocumentVersionMetadata.Builder)DocumentVersionMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentVersions(Collection<DocumentVersionMetadata.BuilderImpl> documentVersions) {
            this.documentVersions = DocumentVersionMetadataListCopier.copyFromBuilder(documentVersions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeDocumentVersionsResponse build() {
            return new DescribeDocumentVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDocumentVersionsResponse> {
        public Builder documentVersions(Collection<DocumentVersionMetadata> var1);

        public Builder documentVersions(DocumentVersionMetadata ... var1);

        public Builder documentVersions(Consumer<DocumentVersionMetadata.Builder> ... var1);

        public Builder marker(String var1);
    }
}

