/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.Activity;
import software.amazon.awssdk.services.workdocs.model.UserActivitiesCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeActivitiesResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, DescribeActivitiesResponse> {
    private static final SdkField<List<Activity>> USER_ACTIVITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserActivities").getter(DescribeActivitiesResponse.getter(DescribeActivitiesResponse::userActivities)).setter(DescribeActivitiesResponse.setter(Builder::userActivities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserActivities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Activity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeActivitiesResponse.getter(DescribeActivitiesResponse::marker)).setter(DescribeActivitiesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ACTIVITIES_FIELD, MARKER_FIELD));
    private final List<Activity> userActivities;
    private final String marker;

    private DescribeActivitiesResponse(BuilderImpl builder) {
        super(builder);
        this.userActivities = builder.userActivities;
        this.marker = builder.marker;
    }

    public boolean hasUserActivities() {
        return this.userActivities != null && !(this.userActivities instanceof SdkAutoConstructList);
    }

    public List<Activity> userActivities() {
        return this.userActivities;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userActivities());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivitiesResponse)) {
            return false;
        }
        DescribeActivitiesResponse other = (DescribeActivitiesResponse)((Object)obj);
        return Objects.equals(this.userActivities(), other.userActivities()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeActivitiesResponse").add("UserActivities", this.userActivities()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserActivities": {
                return Optional.ofNullable(clazz.cast(this.userActivities()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeActivitiesResponse, T> g) {
        return obj -> g.apply((DescribeActivitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private List<Activity> userActivities = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivitiesResponse model) {
            super(model);
            this.userActivities(model.userActivities);
            this.marker(model.marker);
        }

        public final Collection<Activity.Builder> getUserActivities() {
            return this.userActivities != null ? (Collection)this.userActivities.stream().map(Activity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userActivities(Collection<Activity> userActivities) {
            this.userActivities = UserActivitiesCopier.copy(userActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userActivities(Activity ... userActivities) {
            this.userActivities(Arrays.asList(userActivities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userActivities(Consumer<Activity.Builder> ... userActivities) {
            this.userActivities(Stream.of(userActivities).map(c -> (Activity)((Activity.Builder)Activity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserActivities(Collection<Activity.BuilderImpl> userActivities) {
            this.userActivities = UserActivitiesCopier.copyFromBuilder(userActivities);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeActivitiesResponse build() {
            return new DescribeActivitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeActivitiesResponse> {
        public Builder userActivities(Collection<Activity> var1);

        public Builder userActivities(Activity ... var1);

        public Builder userActivities(Consumer<Activity.Builder> ... var1);

        public Builder marker(String var1);
    }
}

