/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.SharedLabelsCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteLabelsRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, DeleteLabelsRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(DeleteLabelsRequest.getter(DeleteLabelsRequest::resourceId)).setter(DeleteLabelsRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceId").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationToken").getter(DeleteLabelsRequest.getter(DeleteLabelsRequest::authenticationToken)).setter(DeleteLabelsRequest.setter(Builder::authenticationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()}).build();
    private static final SdkField<List<String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(DeleteLabelsRequest.getter(DeleteLabelsRequest::labels)).setter(DeleteLabelsRequest.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DELETE_ALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteAll").getter(DeleteLabelsRequest.getter(DeleteLabelsRequest::deleteAll)).setter(DeleteLabelsRequest.setter(Builder::deleteAll)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("deleteAll").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, AUTHENTICATION_TOKEN_FIELD, LABELS_FIELD, DELETE_ALL_FIELD));
    private final String resourceId;
    private final String authenticationToken;
    private final List<String> labels;
    private final Boolean deleteAll;

    private DeleteLabelsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.authenticationToken = builder.authenticationToken;
        this.labels = builder.labels;
        this.deleteAll = builder.deleteAll;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public List<String> labels() {
        return this.labels;
    }

    public Boolean deleteAll() {
        return this.deleteAll;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteAll());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLabelsRequest)) {
            return false;
        }
        DeleteLabelsRequest other = (DeleteLabelsRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.authenticationToken(), other.authenticationToken()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.deleteAll(), other.deleteAll());
    }

    public String toString() {
        return ToString.builder((String)"DeleteLabelsRequest").add("ResourceId", (Object)this.resourceId()).add("AuthenticationToken", (Object)(this.authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Labels", this.hasLabels() ? this.labels() : null).add("DeleteAll", (Object)this.deleteAll()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "DeleteAll": {
                return Optional.ofNullable(clazz.cast(this.deleteAll()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteLabelsRequest, T> g) {
        return obj -> g.apply((DeleteLabelsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String resourceId;
        private String authenticationToken;
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();
        private Boolean deleteAll;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLabelsRequest model) {
            super(model);
            this.resourceId(model.resourceId);
            this.authenticationToken(model.authenticationToken);
            this.labels(model.labels);
            this.deleteAll(model.deleteAll);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final Collection<String> getLabels() {
            if (this.labels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = SharedLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = SharedLabelsCopier.copy(labels);
        }

        public final Boolean getDeleteAll() {
            return this.deleteAll;
        }

        @Override
        public final Builder deleteAll(Boolean deleteAll) {
            this.deleteAll = deleteAll;
            return this;
        }

        public final void setDeleteAll(Boolean deleteAll) {
            this.deleteAll = deleteAll;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLabelsRequest build() {
            return new DeleteLabelsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteLabelsRequest> {
        public Builder resourceId(String var1);

        public Builder authenticationToken(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder deleteAll(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

