/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType;
import software.amazon.awssdk.services.workdocs.model.SubscriptionType;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNotificationSubscriptionRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, CreateNotificationSubscriptionRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNotificationSubscriptionRequest.getter(CreateNotificationSubscriptionRequest::organizationId)).setter(CreateNotificationSubscriptionRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNotificationSubscriptionRequest.getter(CreateNotificationSubscriptionRequest::endpoint)).setter(CreateNotificationSubscriptionRequest.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNotificationSubscriptionRequest.getter(CreateNotificationSubscriptionRequest::protocolAsString)).setter(CreateNotificationSubscriptionRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNotificationSubscriptionRequest.getter(CreateNotificationSubscriptionRequest::subscriptionTypeAsString)).setter(CreateNotificationSubscriptionRequest.setter(Builder::subscriptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD, ENDPOINT_FIELD, PROTOCOL_FIELD, SUBSCRIPTION_TYPE_FIELD));
    private final String organizationId;
    private final String endpoint;
    private final String protocol;
    private final String subscriptionType;

    private CreateNotificationSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.endpoint = builder.endpoint;
        this.protocol = builder.protocol;
        this.subscriptionType = builder.subscriptionType;
    }

    public String organizationId() {
        return this.organizationId;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public SubscriptionProtocolType protocol() {
        return SubscriptionProtocolType.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public SubscriptionType subscriptionType() {
        return SubscriptionType.fromValue(this.subscriptionType);
    }

    public String subscriptionTypeAsString() {
        return this.subscriptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotificationSubscriptionRequest)) {
            return false;
        }
        CreateNotificationSubscriptionRequest other = (CreateNotificationSubscriptionRequest)((Object)obj);
        return Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.subscriptionTypeAsString(), other.subscriptionTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateNotificationSubscriptionRequest").add("OrganizationId", (Object)this.organizationId()).add("Endpoint", (Object)this.endpoint()).add("Protocol", (Object)this.protocolAsString()).add("SubscriptionType", (Object)this.subscriptionTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "SubscriptionType": {
                return Optional.ofNullable(clazz.cast(this.subscriptionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNotificationSubscriptionRequest, T> g) {
        return obj -> g.apply((CreateNotificationSubscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String organizationId;
        private String endpoint;
        private String protocol;
        private String subscriptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNotificationSubscriptionRequest model) {
            super(model);
            this.organizationId(model.organizationId);
            this.endpoint(model.endpoint);
            this.protocol(model.protocol);
            this.subscriptionType(model.subscriptionType);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(SubscriptionProtocolType protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getSubscriptionType() {
            return this.subscriptionType;
        }

        @Override
        public final Builder subscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        @Override
        public final Builder subscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType(subscriptionType == null ? null : subscriptionType.toString());
            return this;
        }

        public final void setSubscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNotificationSubscriptionRequest build() {
            return new CreateNotificationSubscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNotificationSubscriptionRequest> {
        public Builder organizationId(String var1);

        public Builder endpoint(String var1);

        public Builder protocol(String var1);

        public Builder protocol(SubscriptionProtocolType var1);

        public Builder subscriptionType(String var1);

        public Builder subscriptionType(SubscriptionType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

