/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the metadata of a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceMetadata.Builder, ResourceMetadata> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceMetadata::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ORIGINAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceMetadata::originalName)).setter(setter(Builder::originalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalName").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceMetadata::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceMetadata::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final SdkField<UserMetadata> OWNER_FIELD = SdkField.<UserMetadata> builder(MarshallingType.SDK_POJO)
            .getter(getter(ResourceMetadata::owner)).setter(setter(Builder::owner)).constructor(UserMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> PARENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceMetadata::parentId)).setter(setter(Builder::parentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAME_FIELD,
            ORIGINAL_NAME_FIELD, ID_FIELD, VERSION_ID_FIELD, OWNER_FIELD, PARENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String name;

    private final String originalName;

    private final String id;

    private final String versionId;

    private final UserMetadata owner;

    private final String parentId;

    private ResourceMetadata(BuilderImpl builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.originalName = builder.originalName;
        this.id = builder.id;
        this.versionId = builder.versionId;
        this.owner = builder.owner;
        this.parentId = builder.parentId;
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource.
     * @see ResourceType
     */
    public ResourceType type() {
        return ResourceType.fromValue(type);
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource.
     * @see ResourceType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The original name of the resource before a rename operation.
     * </p>
     * 
     * @return The original name of the resource before a rename operation.
     */
    public String originalName() {
        return originalName;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The version ID of the resource. This is an optional field and is filled for action on document version.
     * </p>
     * 
     * @return The version ID of the resource. This is an optional field and is filled for action on document version.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * <p>
     * The owner of the resource.
     * </p>
     * 
     * @return The owner of the resource.
     */
    public UserMetadata owner() {
        return owner;
    }

    /**
     * <p>
     * The parent ID of the resource before a rename operation.
     * </p>
     * 
     * @return The parent ID of the resource before a rename operation.
     */
    public String parentId() {
        return parentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(originalName());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(parentId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceMetadata)) {
            return false;
        }
        ResourceMetadata other = (ResourceMetadata) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(originalName(), other.originalName()) && Objects.equals(id(), other.id())
                && Objects.equals(versionId(), other.versionId()) && Objects.equals(owner(), other.owner())
                && Objects.equals(parentId(), other.parentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceMetadata").add("Type", typeAsString()).add("Name", name())
                .add("OriginalName", originalName()).add("Id", id()).add("VersionId", versionId()).add("Owner", owner())
                .add("ParentId", parentId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OriginalName":
            return Optional.ofNullable(clazz.cast(originalName()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "ParentId":
            return Optional.ofNullable(clazz.cast(parentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceMetadata, T> g) {
        return obj -> g.apply((ResourceMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceMetadata> {
        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param type
         *        The type of resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param type
         *        The type of resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder type(ResourceType type);

        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param name
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The original name of the resource before a rename operation.
         * </p>
         * 
         * @param originalName
         *        The original name of the resource before a rename operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalName(String originalName);

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param id
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The version ID of the resource. This is an optional field and is filled for action on document version.
         * </p>
         * 
         * @param versionId
         *        The version ID of the resource. This is an optional field and is filled for action on document
         *        version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * The owner of the resource.
         * </p>
         * 
         * @param owner
         *        The owner of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(UserMetadata owner);

        /**
         * <p>
         * The owner of the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link UserMetadata.Builder} avoiding the need to
         * create one manually via {@link UserMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #owner(UserMetadata)}.
         * 
         * @param owner
         *        a consumer that will call methods on {@link UserMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #owner(UserMetadata)
         */
        default Builder owner(Consumer<UserMetadata.Builder> owner) {
            return owner(UserMetadata.builder().applyMutation(owner).build());
        }

        /**
         * <p>
         * The parent ID of the resource before a rename operation.
         * </p>
         * 
         * @param parentId
         *        The parent ID of the resource before a rename operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentId(String parentId);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String name;

        private String originalName;

        private String id;

        private String versionId;

        private UserMetadata owner;

        private String parentId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceMetadata model) {
            type(model.type);
            name(model.name);
            originalName(model.originalName);
            id(model.id);
            versionId(model.versionId);
            owner(model.owner);
            parentId(model.parentId);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOriginalName() {
            return originalName;
        }

        @Override
        public final Builder originalName(String originalName) {
            this.originalName = originalName;
            return this;
        }

        public final void setOriginalName(String originalName) {
            this.originalName = originalName;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final UserMetadata.Builder getOwner() {
            return owner != null ? owner.toBuilder() : null;
        }

        @Override
        public final Builder owner(UserMetadata owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(UserMetadata.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        public final String getParentId() {
            return parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        @Override
        public ResourceMetadata build() {
            return new ResourceMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
