/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDocumentVersionsResponse extends WorkDocsResponse implements
        ToCopyableBuilder<DescribeDocumentVersionsResponse.Builder, DescribeDocumentVersionsResponse> {
    private static final SdkField<List<DocumentVersionMetadata>> DOCUMENT_VERSIONS_FIELD = SdkField
            .<List<DocumentVersionMetadata>> builder(MarshallingType.LIST)
            .getter(getter(DescribeDocumentVersionsResponse::documentVersions))
            .setter(setter(Builder::documentVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentVersionMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentVersionMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDocumentVersionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_VERSIONS_FIELD,
            MARKER_FIELD));

    private final List<DocumentVersionMetadata> documentVersions;

    private final String marker;

    private DescribeDocumentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.documentVersions = builder.documentVersions;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the DocumentVersions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDocumentVersions() {
        return documentVersions != null && !(documentVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The document versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDocumentVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The document versions.
     */
    public List<DocumentVersionMetadata> documentVersions() {
        return documentVersions;
    }

    /**
     * <p>
     * The marker to use when requesting the next set of results. If there are no additional results, the string is
     * empty.
     * </p>
     * 
     * @return The marker to use when requesting the next set of results. If there are no additional results, the string
     *         is empty.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentVersions());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentVersionsResponse)) {
            return false;
        }
        DescribeDocumentVersionsResponse other = (DescribeDocumentVersionsResponse) obj;
        return Objects.equals(documentVersions(), other.documentVersions()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDocumentVersionsResponse").add("DocumentVersions", documentVersions())
                .add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentVersions":
            return Optional.ofNullable(clazz.cast(documentVersions()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDocumentVersionsResponse, T> g) {
        return obj -> g.apply((DescribeDocumentVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDocumentVersionsResponse> {
        /**
         * <p>
         * The document versions.
         * </p>
         * 
         * @param documentVersions
         *        The document versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersions(Collection<DocumentVersionMetadata> documentVersions);

        /**
         * <p>
         * The document versions.
         * </p>
         * 
         * @param documentVersions
         *        The document versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersions(DocumentVersionMetadata... documentVersions);

        /**
         * <p>
         * The document versions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DocumentVersionMetadata>.Builder} avoiding
         * the need to create one manually via {@link List<DocumentVersionMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentVersionMetadata>.Builder#build()} is called
         * immediately and its result is passed to {@link #documentVersions(List<DocumentVersionMetadata>)}.
         * 
         * @param documentVersions
         *        a consumer that will call methods on {@link List<DocumentVersionMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentVersions(List<DocumentVersionMetadata>)
         */
        Builder documentVersions(Consumer<DocumentVersionMetadata.Builder>... documentVersions);

        /**
         * <p>
         * The marker to use when requesting the next set of results. If there are no additional results, the string is
         * empty.
         * </p>
         * 
         * @param marker
         *        The marker to use when requesting the next set of results. If there are no additional results, the
         *        string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends WorkDocsResponse.BuilderImpl implements Builder {
        private List<DocumentVersionMetadata> documentVersions = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentVersionsResponse model) {
            super(model);
            documentVersions(model.documentVersions);
            marker(model.marker);
        }

        public final Collection<DocumentVersionMetadata.Builder> getDocumentVersions() {
            return documentVersions != null ? documentVersions.stream().map(DocumentVersionMetadata::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentVersions(Collection<DocumentVersionMetadata> documentVersions) {
            this.documentVersions = DocumentVersionMetadataListCopier.copy(documentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentVersions(DocumentVersionMetadata... documentVersions) {
            documentVersions(Arrays.asList(documentVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentVersions(Consumer<DocumentVersionMetadata.Builder>... documentVersions) {
            documentVersions(Stream.of(documentVersions).map(c -> DocumentVersionMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentVersions(Collection<DocumentVersionMetadata.BuilderImpl> documentVersions) {
            this.documentVersions = DocumentVersionMetadataListCopier.copyFromBuilder(documentVersions);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeDocumentVersionsResponse build() {
            return new DescribeDocumentVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
