/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.workdocs.model.Activity;
import software.amazon.awssdk.services.workdocs.model.UserActivitiesCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeActivitiesResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, DescribeActivitiesResponse> {
    private final List<Activity> userActivities;
    private final String marker;

    private DescribeActivitiesResponse(BuilderImpl builder) {
        super(builder);
        this.userActivities = builder.userActivities;
        this.marker = builder.marker;
    }

    public List<Activity> userActivities() {
        return this.userActivities;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userActivities());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivitiesResponse)) {
            return false;
        }
        DescribeActivitiesResponse other = (DescribeActivitiesResponse)((Object)obj);
        return Objects.equals(this.userActivities(), other.userActivities()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeActivitiesResponse").add("UserActivities", this.userActivities()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserActivities": {
                return Optional.of(clazz.cast(this.userActivities()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private List<Activity> userActivities;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivitiesResponse model) {
            this.userActivities(model.userActivities);
            this.marker(model.marker);
        }

        public final Collection<Activity.Builder> getUserActivities() {
            return this.userActivities != null ? (Collection)this.userActivities.stream().map(Activity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userActivities(Collection<Activity> userActivities) {
            this.userActivities = UserActivitiesCopier.copy(userActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userActivities(Activity ... userActivities) {
            this.userActivities(Arrays.asList(userActivities));
            return this;
        }

        public final void setUserActivities(Collection<Activity.BuilderImpl> userActivities) {
            this.userActivities = UserActivitiesCopier.copyFromBuilder(userActivities);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeActivitiesResponse build() {
            return new DescribeActivitiesResponse(this);
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    CopyableBuilder<Builder, DescribeActivitiesResponse> {
        public Builder userActivities(Collection<Activity> var1);

        public Builder userActivities(Activity ... var1);

        public Builder marker(String var1);
    }
}

