/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest;

@SdkInternalApi
public class GetDocumentVersionRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTHENTICATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Authentication").build();
    private static final MarshallingInfo<String> DOCUMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("DocumentId").build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("VersionId").build();
    private static final MarshallingInfo<String> FIELDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("fields").build();
    private static final MarshallingInfo<Boolean> INCLUDECUSTOMMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("includeCustomMetadata").build();
    private static final GetDocumentVersionRequestModelMarshaller INSTANCE = new GetDocumentVersionRequestModelMarshaller();

    public static GetDocumentVersionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetDocumentVersionRequest getDocumentVersionRequest, ProtocolMarshaller protocolMarshaller) {
        if (getDocumentVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)getDocumentVersionRequest.authenticationToken(), AUTHENTICATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)getDocumentVersionRequest.documentId(), DOCUMENTID_BINDING);
            protocolMarshaller.marshall((Object)getDocumentVersionRequest.versionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall((Object)getDocumentVersionRequest.fields(), FIELDS_BINDING);
            protocolMarshaller.marshall((Object)getDocumentVersionRequest.includeCustomMetadata(), INCLUDECUSTOMMETADATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

