/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;

public final class DescribeDocumentVersionsPaginator
implements SdkIterable<DescribeDocumentVersionsResponse> {
    private final WorkDocsClient client;
    private final DescribeDocumentVersionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeDocumentVersionsPaginator(WorkDocsClient client, DescribeDocumentVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDocumentVersionsResponseFetcher();
    }

    public Iterator<DescribeDocumentVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<DocumentVersionMetadata> documentVersions() {
        Function<DescribeDocumentVersionsResponse, Iterator> getIterator = response -> response != null ? response.documentVersions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeDocumentVersionsResponseFetcher
    implements NextPageFetcher<DescribeDocumentVersionsResponse> {
        private DescribeDocumentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDocumentVersionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDocumentVersionsResponse nextPage(DescribeDocumentVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDocumentVersionsPaginator.this.client.describeDocumentVersions(DescribeDocumentVersionsPaginator.this.firstRequest);
            }
            return DescribeDocumentVersionsPaginator.this.client.describeDocumentVersions((DescribeDocumentVersionsRequest)((Object)DescribeDocumentVersionsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

