/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetFolderRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, GetFolderRequest> {
    private final String authenticationToken;
    private final String folderId;
    private final Boolean includeCustomMetadata;

    private GetFolderRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.folderId = builder.folderId;
        this.includeCustomMetadata = builder.includeCustomMetadata;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String folderId() {
        return this.folderId;
    }

    public Boolean includeCustomMetadata() {
        return this.includeCustomMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.folderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeCustomMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFolderRequest)) {
            return false;
        }
        GetFolderRequest other = (GetFolderRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.folderId(), other.folderId()) && Objects.equals(this.includeCustomMetadata(), other.includeCustomMetadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.authenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.authenticationToken()).append(",");
        }
        if (this.folderId() != null) {
            sb.append("FolderId: ").append(this.folderId()).append(",");
        }
        if (this.includeCustomMetadata() != null) {
            sb.append("IncludeCustomMetadata: ").append(this.includeCustomMetadata()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
            case "FolderId": {
                return Optional.of(clazz.cast(this.folderId()));
            }
            case "IncludeCustomMetadata": {
                return Optional.of(clazz.cast(this.includeCustomMetadata()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String folderId;
        private Boolean includeCustomMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFolderRequest model) {
            this.authenticationToken(model.authenticationToken);
            this.folderId(model.folderId);
            this.includeCustomMetadata(model.includeCustomMetadata);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getFolderId() {
            return this.folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        public final Boolean getIncludeCustomMetadata() {
            return this.includeCustomMetadata;
        }

        @Override
        public final Builder includeCustomMetadata(Boolean includeCustomMetadata) {
            this.includeCustomMetadata = includeCustomMetadata;
            return this;
        }

        public final void setIncludeCustomMetadata(Boolean includeCustomMetadata) {
            this.includeCustomMetadata = includeCustomMetadata;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetFolderRequest build() {
            return new GetFolderRequest(this);
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    CopyableBuilder<Builder, GetFolderRequest> {
        public Builder authenticationToken(String var1);

        public Builder folderId(String var1);

        public Builder includeCustomMetadata(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

