/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;
import software.amazon.awssdk.services.workdocs.model.ResourceStateType;
import software.amazon.awssdk.services.workdocs.model.SharedLabelsCopier;
import software.amazon.awssdk.services.workdocs.transform.DocumentMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DocumentMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, DocumentMetadata> {
    private final String id;
    private final String creatorId;
    private final String parentFolderId;
    private final Instant createdTimestamp;
    private final Instant modifiedTimestamp;
    private final DocumentVersionMetadata latestVersionMetadata;
    private final String resourceState;
    private final List<String> labels;

    private DocumentMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.creatorId = builder.creatorId;
        this.parentFolderId = builder.parentFolderId;
        this.createdTimestamp = builder.createdTimestamp;
        this.modifiedTimestamp = builder.modifiedTimestamp;
        this.latestVersionMetadata = builder.latestVersionMetadata;
        this.resourceState = builder.resourceState;
        this.labels = builder.labels;
    }

    public String id() {
        return this.id;
    }

    public String creatorId() {
        return this.creatorId;
    }

    public String parentFolderId() {
        return this.parentFolderId;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Instant modifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public DocumentVersionMetadata latestVersionMetadata() {
        return this.latestVersionMetadata;
    }

    public ResourceStateType resourceState() {
        return ResourceStateType.fromValue(this.resourceState);
    }

    public String resourceStateString() {
        return this.resourceState;
    }

    public List<String> labels() {
        return this.labels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentMetadata)) {
            return false;
        }
        DocumentMetadata other = (DocumentMetadata)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.creatorId(), other.creatorId()) && Objects.equals(this.parentFolderId(), other.parentFolderId()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.modifiedTimestamp(), other.modifiedTimestamp()) && Objects.equals(this.latestVersionMetadata(), other.latestVersionMetadata()) && Objects.equals(this.resourceStateString(), other.resourceStateString()) && Objects.equals(this.labels(), other.labels());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.creatorId() != null) {
            sb.append("CreatorId: ").append(this.creatorId()).append(",");
        }
        if (this.parentFolderId() != null) {
            sb.append("ParentFolderId: ").append(this.parentFolderId()).append(",");
        }
        if (this.createdTimestamp() != null) {
            sb.append("CreatedTimestamp: ").append(this.createdTimestamp()).append(",");
        }
        if (this.modifiedTimestamp() != null) {
            sb.append("ModifiedTimestamp: ").append(this.modifiedTimestamp()).append(",");
        }
        if (this.latestVersionMetadata() != null) {
            sb.append("LatestVersionMetadata: ").append(this.latestVersionMetadata()).append(",");
        }
        if (this.resourceStateString() != null) {
            sb.append("ResourceState: ").append(this.resourceStateString()).append(",");
        }
        if (this.labels() != null) {
            sb.append("Labels: ").append(this.labels()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "CreatorId": {
                return Optional.of(clazz.cast(this.creatorId()));
            }
            case "ParentFolderId": {
                return Optional.of(clazz.cast(this.parentFolderId()));
            }
            case "CreatedTimestamp": {
                return Optional.of(clazz.cast(this.createdTimestamp()));
            }
            case "ModifiedTimestamp": {
                return Optional.of(clazz.cast(this.modifiedTimestamp()));
            }
            case "LatestVersionMetadata": {
                return Optional.of(clazz.cast(this.latestVersionMetadata()));
            }
            case "ResourceState": {
                return Optional.of(clazz.cast(this.resourceStateString()));
            }
            case "Labels": {
                return Optional.of(clazz.cast(this.labels()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String creatorId;
        private String parentFolderId;
        private Instant createdTimestamp;
        private Instant modifiedTimestamp;
        private DocumentVersionMetadata latestVersionMetadata;
        private String resourceState;
        private List<String> labels;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentMetadata model) {
            this.id(model.id);
            this.creatorId(model.creatorId);
            this.parentFolderId(model.parentFolderId);
            this.createdTimestamp(model.createdTimestamp);
            this.modifiedTimestamp(model.modifiedTimestamp);
            this.latestVersionMetadata(model.latestVersionMetadata);
            this.resourceState(model.resourceState);
            this.labels(model.labels);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getCreatorId() {
            return this.creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        public final String getParentFolderId() {
            return this.parentFolderId;
        }

        @Override
        public final Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        public final void setParentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getModifiedTimestamp() {
            return this.modifiedTimestamp;
        }

        @Override
        public final Builder modifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public final void setModifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
        }

        public final DocumentVersionMetadata.Builder getLatestVersionMetadata() {
            return this.latestVersionMetadata != null ? this.latestVersionMetadata.toBuilder() : null;
        }

        @Override
        public final Builder latestVersionMetadata(DocumentVersionMetadata latestVersionMetadata) {
            this.latestVersionMetadata = latestVersionMetadata;
            return this;
        }

        public final void setLatestVersionMetadata(DocumentVersionMetadata.BuilderImpl latestVersionMetadata) {
            this.latestVersionMetadata = latestVersionMetadata != null ? latestVersionMetadata.build() : null;
        }

        public final String getResourceState() {
            return this.resourceState;
        }

        @Override
        public final Builder resourceState(String resourceState) {
            this.resourceState = resourceState;
            return this;
        }

        @Override
        public final Builder resourceState(ResourceStateType resourceState) {
            this.resourceState(resourceState.toString());
            return this;
        }

        public final void setResourceState(String resourceState) {
            this.resourceState = resourceState;
        }

        public final Collection<String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = SharedLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = SharedLabelsCopier.copy(labels);
        }

        public DocumentMetadata build() {
            return new DocumentMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DocumentMetadata> {
        public Builder id(String var1);

        public Builder creatorId(String var1);

        public Builder parentFolderId(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder modifiedTimestamp(Instant var1);

        public Builder latestVersionMetadata(DocumentVersionMetadata var1);

        default public Builder latestVersionMetadata(Consumer<DocumentVersionMetadata.Builder> latestVersionMetadata) {
            return this.latestVersionMetadata((DocumentVersionMetadata)((DocumentVersionMetadata.Builder)DocumentVersionMetadata.builder().apply(latestVersionMetadata)).build());
        }

        public Builder resourceState(String var1);

        public Builder resourceState(ResourceStateType var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);
    }
}

