/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.PermissionInfo;
import software.amazon.awssdk.services.workdocs.model.PermissionInfoListCopier;
import software.amazon.awssdk.services.workdocs.model.PrincipalType;
import software.amazon.awssdk.services.workdocs.transform.PrincipalMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Principal
implements StructuredPojo,
ToCopyableBuilder<Builder, Principal> {
    private final String id;
    private final String type;
    private final List<PermissionInfo> roles;

    private Principal(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.roles = builder.roles;
    }

    public String id() {
        return this.id;
    }

    public PrincipalType type() {
        return PrincipalType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public List<PermissionInfo> roles() {
        return this.roles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.roles() == null ? 0 : this.roles().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Principal)) {
            return false;
        }
        Principal other = (Principal)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.roles() == null ^ this.roles() == null) {
            return false;
        }
        return other.roles() == null || other.roles().equals(this.roles());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.roles() != null) {
            sb.append("Roles: ").append(this.roles()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "Roles": {
                return Optional.of(clazz.cast(this.roles()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PrincipalMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private List<PermissionInfo> roles;

        private BuilderImpl() {
        }

        private BuilderImpl(Principal model) {
            this.id(model.id);
            this.type(model.type);
            this.roles(model.roles);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PrincipalType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<PermissionInfo.Builder> getRoles() {
            return this.roles != null ? (Collection)this.roles.stream().map(PermissionInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder roles(Collection<PermissionInfo> roles) {
            this.roles = PermissionInfoListCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(PermissionInfo ... roles) {
            this.roles(Arrays.asList(roles));
            return this;
        }

        public final void setRoles(Collection<PermissionInfo.BuilderImpl> roles) {
            this.roles = PermissionInfoListCopier.copyFromBuilder(roles);
        }

        public Principal build() {
            return new Principal(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Principal> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(PrincipalType var1);

        public Builder roles(Collection<PermissionInfo> var1);

        public Builder roles(PermissionInfo ... var1);
    }
}

