/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadataListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDocumentVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeDocumentVersionsResponse> {
    private final List<DocumentVersionMetadata> documentVersions;
    private final String marker;

    private DescribeDocumentVersionsResponse(BuilderImpl builder) {
        this.documentVersions = builder.documentVersions;
        this.marker = builder.marker;
    }

    public List<DocumentVersionMetadata> documentVersions() {
        return this.documentVersions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.documentVersions() == null ? 0 : this.documentVersions().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentVersionsResponse)) {
            return false;
        }
        DescribeDocumentVersionsResponse other = (DescribeDocumentVersionsResponse)((Object)obj);
        if (other.documentVersions() == null ^ this.documentVersions() == null) {
            return false;
        }
        if (other.documentVersions() != null && !other.documentVersions().equals(this.documentVersions())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.documentVersions() != null) {
            sb.append("DocumentVersions: ").append(this.documentVersions()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<DocumentVersionMetadata> documentVersions;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentVersionsResponse model) {
            this.setDocumentVersions(model.documentVersions);
            this.setMarker(model.marker);
        }

        public final Collection<DocumentVersionMetadata> getDocumentVersions() {
            return this.documentVersions;
        }

        @Override
        public final Builder documentVersions(Collection<DocumentVersionMetadata> documentVersions) {
            this.documentVersions = DocumentVersionMetadataListCopier.copy(documentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentVersions(DocumentVersionMetadata ... documentVersions) {
            this.documentVersions(Arrays.asList(documentVersions));
            return this;
        }

        public final void setDocumentVersions(Collection<DocumentVersionMetadata> documentVersions) {
            this.documentVersions = DocumentVersionMetadataListCopier.copy(documentVersions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeDocumentVersionsResponse build() {
            return new DescribeDocumentVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDocumentVersionsResponse> {
        public Builder documentVersions(Collection<DocumentVersionMetadata> var1);

        public Builder documentVersions(DocumentVersionMetadata ... var1);

        public Builder marker(String var1);
    }
}

