/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.SignedHeaderMapCopier;
import software.amazon.awssdk.services.workdocs.transform.UploadMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, UploadMetadata> {
    private final String uploadUrl;
    private final Map<String, String> signedHeaders;

    private UploadMetadata(BuilderImpl builder) {
        this.uploadUrl = builder.uploadUrl;
        this.signedHeaders = builder.signedHeaders;
    }

    public String uploadUrl() {
        return this.uploadUrl;
    }

    public Map<String, String> signedHeaders() {
        return this.signedHeaders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.uploadUrl() == null ? 0 : this.uploadUrl().hashCode());
        hashCode = 31 * hashCode + (this.signedHeaders() == null ? 0 : this.signedHeaders().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadMetadata)) {
            return false;
        }
        UploadMetadata other = (UploadMetadata)obj;
        if (other.uploadUrl() == null ^ this.uploadUrl() == null) {
            return false;
        }
        if (other.uploadUrl() != null && !other.uploadUrl().equals(this.uploadUrl())) {
            return false;
        }
        if (other.signedHeaders() == null ^ this.signedHeaders() == null) {
            return false;
        }
        return other.signedHeaders() == null || other.signedHeaders().equals(this.signedHeaders());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.uploadUrl() != null) {
            sb.append("UploadUrl: ").append(this.uploadUrl()).append(",");
        }
        if (this.signedHeaders() != null) {
            sb.append("SignedHeaders: ").append(this.signedHeaders()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UploadMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String uploadUrl;
        private Map<String, String> signedHeaders;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadMetadata model) {
            this.setUploadUrl(model.uploadUrl);
            this.setSignedHeaders(model.signedHeaders);
        }

        public final String getUploadUrl() {
            return this.uploadUrl;
        }

        @Override
        public final Builder uploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
            return this;
        }

        public final void setUploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
        }

        public final Map<String, String> getSignedHeaders() {
            return this.signedHeaders;
        }

        @Override
        public final Builder signedHeaders(Map<String, String> signedHeaders) {
            this.signedHeaders = SignedHeaderMapCopier.copy(signedHeaders);
            return this;
        }

        public final void setSignedHeaders(Map<String, String> signedHeaders) {
            this.signedHeaders = SignedHeaderMapCopier.copy(signedHeaders);
        }

        public UploadMetadata build() {
            return new UploadMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UploadMetadata> {
        public Builder uploadUrl(String var1);

        public Builder signedHeaders(Map<String, String> var1);
    }
}

