/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.UpdateUserRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateUserRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTHENTICATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Authentication").isBinary(false).build();
    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("UserId").isBinary(false).build();
    private static final MarshallingInfo<String> GIVENNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GivenName").isBinary(false).build();
    private static final MarshallingInfo<String> SURNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Surname").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STORAGERULE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageRule").isBinary(false).build();
    private static final MarshallingInfo<String> TIMEZONEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeZoneId").isBinary(false).build();
    private static final MarshallingInfo<String> LOCALE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Locale").isBinary(false).build();
    private static final MarshallingInfo<String> GRANTPOWERUSERPRIVILEGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrantPoweruserPrivileges").isBinary(false).build();
    private static final UpdateUserRequestModelMarshaller INSTANCE = new UpdateUserRequestModelMarshaller();

    private UpdateUserRequestModelMarshaller() {
    }

    public static UpdateUserRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateUserRequest updateUserRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateUserRequest), (String)"updateUserRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateUserRequest.authenticationToken(), AUTHENTICATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)updateUserRequest.userId(), USERID_BINDING);
            protocolMarshaller.marshall((Object)updateUserRequest.givenName(), GIVENNAME_BINDING);
            protocolMarshaller.marshall((Object)updateUserRequest.surname(), SURNAME_BINDING);
            protocolMarshaller.marshall((Object)updateUserRequest.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)updateUserRequest.storageRule(), STORAGERULE_BINDING);
            protocolMarshaller.marshall((Object)updateUserRequest.timeZoneId(), TIMEZONEID_BINDING);
            protocolMarshaller.marshall((Object)updateUserRequest.localeAsString(), LOCALE_BINDING);
            protocolMarshaller.marshall((Object)updateUserRequest.grantPoweruserPrivilegesAsString(), GRANTPOWERUSERPRIVILEGES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

