/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.transform.UserMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, UserMetadata> {
    private final String id;
    private final String username;
    private final String givenName;
    private final String surname;
    private final String emailAddress;

    private UserMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.username = builder.username;
        this.givenName = builder.givenName;
        this.surname = builder.surname;
        this.emailAddress = builder.emailAddress;
    }

    public String id() {
        return this.id;
    }

    public String username() {
        return this.username;
    }

    public String givenName() {
        return this.givenName;
    }

    public String surname() {
        return this.surname;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.givenName());
        hashCode = 31 * hashCode + Objects.hashCode(this.surname());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserMetadata)) {
            return false;
        }
        UserMetadata other = (UserMetadata)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.givenName(), other.givenName()) && Objects.equals(this.surname(), other.surname()) && Objects.equals(this.emailAddress(), other.emailAddress());
    }

    public String toString() {
        return ToString.builder((String)"UserMetadata").add("Id", (Object)this.id()).add("Username", (Object)this.username()).add("GivenName", (Object)this.givenName()).add("Surname", (Object)this.surname()).add("EmailAddress", (Object)this.emailAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "GivenName": {
                return Optional.ofNullable(clazz.cast(this.givenName()));
            }
            case "Surname": {
                return Optional.ofNullable(clazz.cast(this.surname()));
            }
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String username;
        private String givenName;
        private String surname;
        private String emailAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(UserMetadata model) {
            this.id(model.id);
            this.username(model.username);
            this.givenName(model.givenName);
            this.surname(model.surname);
            this.emailAddress(model.emailAddress);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getGivenName() {
            return this.givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        public final String getSurname() {
            return this.surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public UserMetadata build() {
            return new UserMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UserMetadata> {
        public Builder id(String var1);

        public Builder username(String var1);

        public Builder givenName(String var1);

        public Builder surname(String var1);

        public Builder emailAddress(String var1);
    }
}

