/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.CustomMetadataKeyListCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteCustomMetadataRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, DeleteCustomMetadataRequest> {
    private final String authenticationToken;
    private final String resourceId;
    private final String versionId;
    private final List<String> keys;
    private final Boolean deleteAll;

    private DeleteCustomMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.resourceId = builder.resourceId;
        this.versionId = builder.versionId;
        this.keys = builder.keys;
        this.deleteAll = builder.deleteAll;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String versionId() {
        return this.versionId;
    }

    public List<String> keys() {
        return this.keys;
    }

    public Boolean deleteAll() {
        return this.deleteAll;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keys());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteAll());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCustomMetadataRequest)) {
            return false;
        }
        DeleteCustomMetadataRequest other = (DeleteCustomMetadataRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.keys(), other.keys()) && Objects.equals(this.deleteAll(), other.deleteAll());
    }

    public String toString() {
        return ToString.builder((String)"DeleteCustomMetadataRequest").add("AuthenticationToken", (Object)this.authenticationToken()).add("ResourceId", (Object)this.resourceId()).add("VersionId", (Object)this.versionId()).add("Keys", this.keys()).add("DeleteAll", (Object)this.deleteAll()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "Keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
            case "DeleteAll": {
                return Optional.ofNullable(clazz.cast(this.deleteAll()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String resourceId;
        private String versionId;
        private List<String> keys = DefaultSdkAutoConstructList.getInstance();
        private Boolean deleteAll;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCustomMetadataRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.resourceId(model.resourceId);
            this.versionId(model.versionId);
            this.keys(model.keys);
            this.deleteAll(model.deleteAll);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Collection<String> getKeys() {
            return this.keys;
        }

        @Override
        public final Builder keys(Collection<String> keys) {
            this.keys = CustomMetadataKeyListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(String ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = CustomMetadataKeyListCopier.copy(keys);
        }

        public final Boolean getDeleteAll() {
            return this.deleteAll;
        }

        @Override
        public final Builder deleteAll(Boolean deleteAll) {
            this.deleteAll = deleteAll;
            return this;
        }

        public final void setDeleteAll(Boolean deleteAll) {
            this.deleteAll = deleteAll;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCustomMetadataRequest build() {
            return new DeleteCustomMetadataRequest(this);
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    CopyableBuilder<Builder, DeleteCustomMetadataRequest> {
        public Builder authenticationToken(String var1);

        public Builder resourceId(String var1);

        public Builder versionId(String var1);

        public Builder keys(Collection<String> var1);

        public Builder keys(String ... var1);

        public Builder deleteAll(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

