/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.SharePrincipal;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SharePrincipalMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> ROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Role").isBinary(false).build();
    private static final SharePrincipalMarshaller INSTANCE = new SharePrincipalMarshaller();

    private SharePrincipalMarshaller() {
    }

    public static SharePrincipalMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SharePrincipal sharePrincipal, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sharePrincipal, (String)"sharePrincipal");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sharePrincipal.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)sharePrincipal.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)sharePrincipal.roleAsString(), ROLE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

