/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.GetFolderRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetFolderRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTHENTICATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Authentication").isBinary(false).build();
    private static final MarshallingInfo<String> FOLDERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("FolderId").isBinary(false).build();
    private static final MarshallingInfo<Boolean> INCLUDECUSTOMMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("includeCustomMetadata").isBinary(false).build();
    private static final GetFolderRequestModelMarshaller INSTANCE = new GetFolderRequestModelMarshaller();

    private GetFolderRequestModelMarshaller() {
    }

    public static GetFolderRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetFolderRequest getFolderRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getFolderRequest), (String)"getFolderRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getFolderRequest.authenticationToken(), AUTHENTICATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)getFolderRequest.folderId(), FOLDERID_BINDING);
            protocolMarshaller.marshall((Object)getFolderRequest.includeCustomMetadata(), INCLUDECUSTOMMETADATA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

