/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.FolderMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FolderMetadataMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> CREATORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatorId").isBinary(false).build();
    private static final MarshallingInfo<String> PARENTFOLDERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentFolderId").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTimestamp").isBinary(false).build();
    private static final MarshallingInfo<Instant> MODIFIEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModifiedTimestamp").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCESTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceState").isBinary(false).build();
    private static final MarshallingInfo<String> SIGNATURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Signature").isBinary(false).build();
    private static final MarshallingInfo<List> LABELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Labels").isBinary(false).build();
    private static final MarshallingInfo<Long> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").isBinary(false).build();
    private static final MarshallingInfo<Long> LATESTVERSIONSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestVersionSize").isBinary(false).build();
    private static final FolderMetadataMarshaller INSTANCE = new FolderMetadataMarshaller();

    private FolderMetadataMarshaller() {
    }

    public static FolderMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FolderMetadata folderMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)folderMetadata, (String)"folderMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)folderMetadata.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)folderMetadata.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)folderMetadata.creatorId(), CREATORID_BINDING);
            protocolMarshaller.marshall((Object)folderMetadata.parentFolderId(), PARENTFOLDERID_BINDING);
            protocolMarshaller.marshall((Object)folderMetadata.createdTimestamp(), CREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)folderMetadata.modifiedTimestamp(), MODIFIEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)folderMetadata.resourceStateAsString(), RESOURCESTATE_BINDING);
            protocolMarshaller.marshall((Object)folderMetadata.signature(), SIGNATURE_BINDING);
            protocolMarshaller.marshall(folderMetadata.labels(), LABELS_BINDING);
            protocolMarshaller.marshall((Object)folderMetadata.size(), SIZE_BINDING);
            protocolMarshaller.marshall((Object)folderMetadata.latestVersionSize(), LATESTVERSIONSIZE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

