/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AddResourcePermissionsRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTHENTICATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Authentication").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("ResourceId").isBinary(false).build();
    private static final MarshallingInfo<List> PRINCIPALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Principals").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATIONOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationOptions").isBinary(false).build();
    private static final AddResourcePermissionsRequestModelMarshaller INSTANCE = new AddResourcePermissionsRequestModelMarshaller();

    private AddResourcePermissionsRequestModelMarshaller() {
    }

    public static AddResourcePermissionsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AddResourcePermissionsRequest addResourcePermissionsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)addResourcePermissionsRequest), (String)"addResourcePermissionsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)addResourcePermissionsRequest.authenticationToken(), AUTHENTICATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)addResourcePermissionsRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall(addResourcePermissionsRequest.principals(), PRINCIPALS_BINDING);
            protocolMarshaller.marshall((Object)addResourcePermissionsRequest.notificationOptions(), NOTIFICATIONOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

