/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionStatus;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDocumentVersionRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, UpdateDocumentVersionRequest> {
    private final String authenticationToken;
    private final String documentId;
    private final String versionId;
    private final String versionStatus;

    private UpdateDocumentVersionRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.documentId = builder.documentId;
        this.versionId = builder.versionId;
        this.versionStatus = builder.versionStatus;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String documentId() {
        return this.documentId;
    }

    public String versionId() {
        return this.versionId;
    }

    public DocumentVersionStatus versionStatus() {
        return DocumentVersionStatus.fromValue(this.versionStatus);
    }

    public String versionStatusAsString() {
        return this.versionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDocumentVersionRequest)) {
            return false;
        }
        UpdateDocumentVersionRequest other = (UpdateDocumentVersionRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.documentId(), other.documentId()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.versionStatusAsString(), other.versionStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDocumentVersionRequest").add("AuthenticationToken", (Object)this.authenticationToken()).add("DocumentId", (Object)this.documentId()).add("VersionId", (Object)this.versionId()).add("VersionStatus", (Object)this.versionStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "DocumentId": {
                return Optional.ofNullable(clazz.cast(this.documentId()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "VersionStatus": {
                return Optional.ofNullable(clazz.cast(this.versionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String documentId;
        private String versionId;
        private String versionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDocumentVersionRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.documentId(model.documentId);
            this.versionId(model.versionId);
            this.versionStatus(model.versionStatus);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getVersionStatus() {
            return this.versionStatus;
        }

        @Override
        public final Builder versionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
            return this;
        }

        @Override
        public final Builder versionStatus(DocumentVersionStatus versionStatus) {
            this.versionStatus(versionStatus.toString());
            return this;
        }

        public final void setVersionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDocumentVersionRequest build() {
            return new UpdateDocumentVersionRequest(this);
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    CopyableBuilder<Builder, UpdateDocumentVersionRequest> {
        public Builder authenticationToken(String var1);

        public Builder documentId(String var1);

        public Builder versionId(String var1);

        public Builder versionStatus(String var1);

        public Builder versionStatus(DocumentVersionStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

