/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.Subscription;
import software.amazon.awssdk.services.workdocs.model.SubscriptionListCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNotificationSubscriptionsResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, DescribeNotificationSubscriptionsResponse> {
    private final List<Subscription> subscriptions;
    private final String marker;

    private DescribeNotificationSubscriptionsResponse(BuilderImpl builder) {
        super(builder);
        this.subscriptions = builder.subscriptions;
        this.marker = builder.marker;
    }

    public List<Subscription> subscriptions() {
        return this.subscriptions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationSubscriptionsResponse)) {
            return false;
        }
        DescribeNotificationSubscriptionsResponse other = (DescribeNotificationSubscriptionsResponse)((Object)obj);
        return Objects.equals(this.subscriptions(), other.subscriptions()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeNotificationSubscriptionsResponse").add("Subscriptions", this.subscriptions()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subscriptions": {
                return Optional.ofNullable(clazz.cast(this.subscriptions()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private List<Subscription> subscriptions = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationSubscriptionsResponse model) {
            super(model);
            this.subscriptions(model.subscriptions);
            this.marker(model.marker);
        }

        public final Collection<Subscription.Builder> getSubscriptions() {
            return this.subscriptions != null ? (Collection)this.subscriptions.stream().map(Subscription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Subscription ... subscriptions) {
            this.subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Consumer<Subscription.Builder> ... subscriptions) {
            this.subscriptions(Stream.of(subscriptions).map(c -> (Subscription)((Subscription.Builder)Subscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copyFromBuilder(subscriptions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeNotificationSubscriptionsResponse build() {
            return new DescribeNotificationSubscriptionsResponse(this);
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    CopyableBuilder<Builder, DescribeNotificationSubscriptionsResponse> {
        public Builder subscriptions(Collection<Subscription> var1);

        public Builder subscriptions(Subscription ... var1);

        public Builder subscriptions(Consumer<Subscription.Builder> ... var1);

        public Builder marker(String var1);
    }
}

