/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadataListCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDocumentVersionsResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, DescribeDocumentVersionsResponse> {
    private final List<DocumentVersionMetadata> documentVersions;
    private final String marker;

    private DescribeDocumentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.documentVersions = builder.documentVersions;
        this.marker = builder.marker;
    }

    public List<DocumentVersionMetadata> documentVersions() {
        return this.documentVersions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentVersionsResponse)) {
            return false;
        }
        DescribeDocumentVersionsResponse other = (DescribeDocumentVersionsResponse)((Object)obj);
        return Objects.equals(this.documentVersions(), other.documentVersions()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDocumentVersionsResponse").add("DocumentVersions", this.documentVersions()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentVersions": {
                return Optional.ofNullable(clazz.cast(this.documentVersions()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private List<DocumentVersionMetadata> documentVersions = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentVersionsResponse model) {
            super(model);
            this.documentVersions(model.documentVersions);
            this.marker(model.marker);
        }

        public final Collection<DocumentVersionMetadata.Builder> getDocumentVersions() {
            return this.documentVersions != null ? (Collection)this.documentVersions.stream().map(DocumentVersionMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentVersions(Collection<DocumentVersionMetadata> documentVersions) {
            this.documentVersions = DocumentVersionMetadataListCopier.copy(documentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentVersions(DocumentVersionMetadata ... documentVersions) {
            this.documentVersions(Arrays.asList(documentVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentVersions(Consumer<DocumentVersionMetadata.Builder> ... documentVersions) {
            this.documentVersions(Stream.of(documentVersions).map(c -> (DocumentVersionMetadata)((DocumentVersionMetadata.Builder)DocumentVersionMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentVersions(Collection<DocumentVersionMetadata.BuilderImpl> documentVersions) {
            this.documentVersions = DocumentVersionMetadataListCopier.copyFromBuilder(documentVersions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeDocumentVersionsResponse build() {
            return new DescribeDocumentVersionsResponse(this);
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    CopyableBuilder<Builder, DescribeDocumentVersionsResponse> {
        public Builder documentVersions(Collection<DocumentVersionMetadata> var1);

        public Builder documentVersions(DocumentVersionMetadata ... var1);

        public Builder documentVersions(Consumer<DocumentVersionMetadata.Builder> ... var1);

        public Builder marker(String var1);
    }
}

