/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.Comment;
import software.amazon.awssdk.services.workdocs.model.CommentListCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCommentsResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, DescribeCommentsResponse> {
    private final List<Comment> comments;
    private final String marker;

    private DescribeCommentsResponse(BuilderImpl builder) {
        super(builder);
        this.comments = builder.comments;
        this.marker = builder.marker;
    }

    public List<Comment> comments() {
        return this.comments;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comments());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommentsResponse)) {
            return false;
        }
        DescribeCommentsResponse other = (DescribeCommentsResponse)((Object)obj);
        return Objects.equals(this.comments(), other.comments()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCommentsResponse").add("Comments", this.comments()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comments": {
                return Optional.ofNullable(clazz.cast(this.comments()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private List<Comment> comments = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommentsResponse model) {
            super(model);
            this.comments(model.comments);
            this.marker(model.marker);
        }

        public final Collection<Comment.Builder> getComments() {
            return this.comments != null ? (Collection)this.comments.stream().map(Comment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder comments(Collection<Comment> comments) {
            this.comments = CommentListCopier.copy(comments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comments(Comment ... comments) {
            this.comments(Arrays.asList(comments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comments(Consumer<Comment.Builder> ... comments) {
            this.comments(Stream.of(comments).map(c -> (Comment)((Comment.Builder)Comment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComments(Collection<Comment.BuilderImpl> comments) {
            this.comments = CommentListCopier.copyFromBuilder(comments);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeCommentsResponse build() {
            return new DescribeCommentsResponse(this);
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    CopyableBuilder<Builder, DescribeCommentsResponse> {
        public Builder comments(Collection<Comment> var1);

        public Builder comments(Comment ... var1);

        public Builder comments(Consumer<Comment.Builder> ... var1);

        public Builder marker(String var1);
    }
}

