/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.Subscription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SubscriptionMarshaller {
    private static final MarshallingInfo<String> SUBSCRIPTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubscriptionId").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndPoint").isBinary(false).build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Protocol").isBinary(false).build();
    private static final SubscriptionMarshaller INSTANCE = new SubscriptionMarshaller();

    private SubscriptionMarshaller() {
    }

    public static SubscriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Subscription subscription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)subscription, (String)"subscription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)subscription.subscriptionId(), SUBSCRIPTIONID_BINDING);
            protocolMarshaller.marshall((Object)subscription.endPoint(), ENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)subscription.protocolAsString(), PROTOCOL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

