/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.ResourceMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceMetadataMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> ORIGINALNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OriginalName").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Owner").isBinary(false).build();
    private static final MarshallingInfo<String> PARENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentId").isBinary(false).build();
    private static final ResourceMetadataMarshaller INSTANCE = new ResourceMetadataMarshaller();

    private ResourceMetadataMarshaller() {
    }

    public static ResourceMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceMetadata resourceMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceMetadata, (String)"resourceMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceMetadata.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)resourceMetadata.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)resourceMetadata.originalName(), ORIGINALNAME_BINDING);
            protocolMarshaller.marshall((Object)resourceMetadata.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)resourceMetadata.versionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall((Object)resourceMetadata.owner(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)resourceMetadata.parentId(), PARENTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

