/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.PermissionInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PermissionInfoMarshaller {
    private static final MarshallingInfo<String> ROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Role").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final PermissionInfoMarshaller INSTANCE = new PermissionInfoMarshaller();

    private PermissionInfoMarshaller() {
    }

    public static PermissionInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PermissionInfo permissionInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)permissionInfo, (String)"permissionInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)permissionInfo.roleAsString(), ROLE_BINDING);
            protocolMarshaller.marshall((Object)permissionInfo.typeAsString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

