/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeUsersRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTHENTICATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Authentication").isBinary(false).build();
    private static final MarshallingInfo<String> ORGANIZATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("organizationId").isBinary(false).build();
    private static final MarshallingInfo<String> USERIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("userIds").isBinary(false).build();
    private static final MarshallingInfo<String> QUERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("query").isBinary(false).build();
    private static final MarshallingInfo<String> INCLUDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("include").isBinary(false).build();
    private static final MarshallingInfo<String> ORDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("order").isBinary(false).build();
    private static final MarshallingInfo<String> SORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("sort").isBinary(false).build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("marker").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("limit").isBinary(false).build();
    private static final MarshallingInfo<String> FIELDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("fields").isBinary(false).build();
    private static final DescribeUsersRequestModelMarshaller INSTANCE = new DescribeUsersRequestModelMarshaller();

    private DescribeUsersRequestModelMarshaller() {
    }

    public static DescribeUsersRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeUsersRequest describeUsersRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeUsersRequest), (String)"describeUsersRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeUsersRequest.authenticationToken(), AUTHENTICATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)describeUsersRequest.organizationId(), ORGANIZATIONID_BINDING);
            protocolMarshaller.marshall((Object)describeUsersRequest.userIds(), USERIDS_BINDING);
            protocolMarshaller.marshall((Object)describeUsersRequest.query(), QUERY_BINDING);
            protocolMarshaller.marshall((Object)describeUsersRequest.includeAsString(), INCLUDE_BINDING);
            protocolMarshaller.marshall((Object)describeUsersRequest.orderAsString(), ORDER_BINDING);
            protocolMarshaller.marshall((Object)describeUsersRequest.sortAsString(), SORT_BINDING);
            protocolMarshaller.marshall((Object)describeUsersRequest.marker(), MARKER_BINDING);
            protocolMarshaller.marshall((Object)describeUsersRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)describeUsersRequest.fields(), FIELDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

