/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.CommentMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CommentMetadataMarshaller {
    private static final MarshallingInfo<String> COMMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommentId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONTRIBUTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Contributor").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTimestamp").isBinary(false).build();
    private static final MarshallingInfo<String> COMMENTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommentStatus").isBinary(false).build();
    private static final MarshallingInfo<String> RECIPIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecipientId").isBinary(false).build();
    private static final CommentMetadataMarshaller INSTANCE = new CommentMetadataMarshaller();

    private CommentMetadataMarshaller() {
    }

    public static CommentMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CommentMetadata commentMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)commentMetadata, (String)"commentMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)commentMetadata.commentId(), COMMENTID_BINDING);
            protocolMarshaller.marshall((Object)commentMetadata.contributor(), CONTRIBUTOR_BINDING);
            protocolMarshaller.marshall((Object)commentMetadata.createdTimestamp(), CREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)commentMetadata.commentStatusAsString(), COMMENTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)commentMetadata.recipientId(), RECIPIENTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

