/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.SignedHeaderMapCopier;
import software.amazon.awssdk.services.workdocs.transform.UploadMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, UploadMetadata> {
    private final String uploadUrl;
    private final Map<String, String> signedHeaders;

    private UploadMetadata(BuilderImpl builder) {
        this.uploadUrl = builder.uploadUrl;
        this.signedHeaders = builder.signedHeaders;
    }

    public String uploadUrl() {
        return this.uploadUrl;
    }

    public Map<String, String> signedHeaders() {
        return this.signedHeaders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.signedHeaders());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadMetadata)) {
            return false;
        }
        UploadMetadata other = (UploadMetadata)obj;
        return Objects.equals(this.uploadUrl(), other.uploadUrl()) && Objects.equals(this.signedHeaders(), other.signedHeaders());
    }

    public String toString() {
        return ToString.builder((String)"UploadMetadata").add("UploadUrl", (Object)this.uploadUrl()).add("SignedHeaders", this.signedHeaders()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UploadUrl": {
                return Optional.of(clazz.cast(this.uploadUrl()));
            }
            case "SignedHeaders": {
                return Optional.of(clazz.cast(this.signedHeaders()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UploadMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String uploadUrl;
        private Map<String, String> signedHeaders;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadMetadata model) {
            this.uploadUrl(model.uploadUrl);
            this.signedHeaders(model.signedHeaders);
        }

        public final String getUploadUrl() {
            return this.uploadUrl;
        }

        @Override
        public final Builder uploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
            return this;
        }

        public final void setUploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
        }

        public final Map<String, String> getSignedHeaders() {
            return this.signedHeaders;
        }

        @Override
        public final Builder signedHeaders(Map<String, String> signedHeaders) {
            this.signedHeaders = SignedHeaderMapCopier.copy(signedHeaders);
            return this;
        }

        public final void setSignedHeaders(Map<String, String> signedHeaders) {
            this.signedHeaders = SignedHeaderMapCopier.copy(signedHeaders);
        }

        public UploadMetadata build() {
            return new UploadMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UploadMetadata> {
        public Builder uploadUrl(String var1);

        public Builder signedHeaders(Map<String, String> var1);
    }
}

