/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import java.util.Date;
import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.DocumentMetadata;

@SdkInternalApi
public class DocumentMetadataMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> CREATORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatorId").build();
    private static final MarshallingInfo<String> PARENTFOLDERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentFolderId").build();
    private static final MarshallingInfo<Date> CREATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTimestamp").build();
    private static final MarshallingInfo<Date> MODIFIEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModifiedTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> LATESTVERSIONMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestVersionMetadata").build();
    private static final MarshallingInfo<String> RESOURCESTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceState").build();
    private static final MarshallingInfo<List> LABELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Labels").build();
    private static final DocumentMetadataMarshaller instance = new DocumentMetadataMarshaller();

    public static DocumentMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(DocumentMetadata documentMetadata, ProtocolMarshaller protocolMarshaller) {
        if (documentMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)documentMetadata.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)documentMetadata.creatorId(), CREATORID_BINDING);
            protocolMarshaller.marshall((Object)documentMetadata.parentFolderId(), PARENTFOLDERID_BINDING);
            protocolMarshaller.marshall((Object)documentMetadata.createdTimestamp(), CREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)documentMetadata.modifiedTimestamp(), MODIFIEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)documentMetadata.latestVersionMetadata(), LATESTVERSIONMETADATA_BINDING);
            protocolMarshaller.marshall((Object)documentMetadata.resourceState(), RESOURCESTATE_BINDING);
            protocolMarshaller.marshall(documentMetadata.labels(), LABELS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

