/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wisdom.model.Highlight;
import software.amazon.awssdk.services.wisdom.model.HighlightsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentText
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentText> {
    private static final SdkField<List<Highlight>> HIGHLIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("highlights").getter(DocumentText.getter(DocumentText::highlights)).setter(DocumentText.setter(Builder::highlights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("highlights").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Highlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(DocumentText.getter(DocumentText::text)).setter(DocumentText.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIGHLIGHTS_FIELD, TEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DocumentText.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Highlight> highlights;
    private final String text;

    private DocumentText(BuilderImpl builder) {
        this.highlights = builder.highlights;
        this.text = builder.text;
    }

    public final boolean hasHighlights() {
        return this.highlights != null && !(this.highlights instanceof SdkAutoConstructList);
    }

    public final List<Highlight> highlights() {
        return this.highlights;
    }

    public final String text() {
        return this.text;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHighlights() ? this.highlights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentText)) {
            return false;
        }
        DocumentText other = (DocumentText)obj;
        return this.hasHighlights() == other.hasHighlights() && Objects.equals(this.highlights(), other.highlights()) && Objects.equals(this.text(), other.text());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentText").add("Highlights", this.hasHighlights() ? this.highlights() : null).add("Text", (Object)(this.text() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "highlights": {
                return Optional.ofNullable(clazz.cast(this.highlights()));
            }
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("highlights", HIGHLIGHTS_FIELD);
        map.put("text", TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentText, T> g) {
        return obj -> g.apply((DocumentText)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Highlight> highlights = DefaultSdkAutoConstructList.getInstance();
        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentText model) {
            this.highlights(model.highlights);
            this.text(model.text);
        }

        public final List<Highlight.Builder> getHighlights() {
            List<Highlight.Builder> result = HighlightsCopier.copyToBuilder(this.highlights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHighlights(Collection<Highlight.BuilderImpl> highlights) {
            this.highlights = HighlightsCopier.copyFromBuilder(highlights);
        }

        @Override
        public final Builder highlights(Collection<Highlight> highlights) {
            this.highlights = HighlightsCopier.copy(highlights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder highlights(Highlight ... highlights) {
            this.highlights(Arrays.asList(highlights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder highlights(Consumer<Highlight.Builder> ... highlights) {
            this.highlights(Stream.of(highlights).map(c -> (Highlight)((Highlight.Builder)Highlight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public DocumentText build() {
            return new DocumentText(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentText> {
        public Builder highlights(Collection<Highlight> var1);

        public Builder highlights(Highlight ... var1);

        public Builder highlights(Consumer<Highlight.Builder> ... var1);

        public Builder text(String var1);
    }
}

