/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wisdom.model.ContentMetadataCopier;
import software.amazon.awssdk.services.wisdom.model.ExternalSourceConfiguration;
import software.amazon.awssdk.services.wisdom.model.ImportJobType;
import software.amazon.awssdk.services.wisdom.model.WisdomRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartImportJobRequest
extends WisdomRequest
implements ToCopyableBuilder<Builder, StartImportJobRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartImportJobRequest.getter(StartImportJobRequest::clientToken)).setter(StartImportJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<ExternalSourceConfiguration> EXTERNAL_SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("externalSourceConfiguration").getter(StartImportJobRequest.getter(StartImportJobRequest::externalSourceConfiguration)).setter(StartImportJobRequest.setter(Builder::externalSourceConfiguration)).constructor(ExternalSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalSourceConfiguration").build()}).build();
    private static final SdkField<String> IMPORT_JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importJobType").getter(StartImportJobRequest.getter(StartImportJobRequest::importJobTypeAsString)).setter(StartImportJobRequest.setter(Builder::importJobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importJobType").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(StartImportJobRequest.getter(StartImportJobRequest::knowledgeBaseId)).setter(StartImportJobRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metadata").getter(StartImportJobRequest.getter(StartImportJobRequest::metadata)).setter(StartImportJobRequest.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadId").getter(StartImportJobRequest.getter(StartImportJobRequest::uploadId)).setter(StartImportJobRequest.setter(Builder::uploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, EXTERNAL_SOURCE_CONFIGURATION_FIELD, IMPORT_JOB_TYPE_FIELD, KNOWLEDGE_BASE_ID_FIELD, METADATA_FIELD, UPLOAD_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartImportJobRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final ExternalSourceConfiguration externalSourceConfiguration;
    private final String importJobType;
    private final String knowledgeBaseId;
    private final Map<String, String> metadata;
    private final String uploadId;

    private StartImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.externalSourceConfiguration = builder.externalSourceConfiguration;
        this.importJobType = builder.importJobType;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.metadata = builder.metadata;
        this.uploadId = builder.uploadId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ExternalSourceConfiguration externalSourceConfiguration() {
        return this.externalSourceConfiguration;
    }

    public final ImportJobType importJobType() {
        return ImportJobType.fromValue(this.importJobType);
    }

    public final String importJobTypeAsString() {
        return this.importJobType;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public final String uploadId() {
        return this.uploadId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.importJobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportJobRequest)) {
            return false;
        }
        StartImportJobRequest other = (StartImportJobRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.externalSourceConfiguration(), other.externalSourceConfiguration()) && Objects.equals(this.importJobTypeAsString(), other.importJobTypeAsString()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.uploadId(), other.uploadId());
    }

    public final String toString() {
        return ToString.builder((String)"StartImportJobRequest").add("ClientToken", (Object)this.clientToken()).add("ExternalSourceConfiguration", (Object)this.externalSourceConfiguration()).add("ImportJobType", (Object)this.importJobTypeAsString()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("Metadata", this.hasMetadata() ? this.metadata() : null).add("UploadId", (Object)this.uploadId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "externalSourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.externalSourceConfiguration()));
            }
            case "importJobType": {
                return Optional.ofNullable(clazz.cast(this.importJobTypeAsString()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "uploadId": {
                return Optional.ofNullable(clazz.cast(this.uploadId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("externalSourceConfiguration", EXTERNAL_SOURCE_CONFIGURATION_FIELD);
        map.put("importJobType", IMPORT_JOB_TYPE_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("uploadId", UPLOAD_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartImportJobRequest, T> g) {
        return obj -> g.apply((StartImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WisdomRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private ExternalSourceConfiguration externalSourceConfiguration;
        private String importJobType;
        private String knowledgeBaseId;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();
        private String uploadId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportJobRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.externalSourceConfiguration(model.externalSourceConfiguration);
            this.importJobType(model.importJobType);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.metadata(model.metadata);
            this.uploadId(model.uploadId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ExternalSourceConfiguration.Builder getExternalSourceConfiguration() {
            return this.externalSourceConfiguration != null ? this.externalSourceConfiguration.toBuilder() : null;
        }

        public final void setExternalSourceConfiguration(ExternalSourceConfiguration.BuilderImpl externalSourceConfiguration) {
            this.externalSourceConfiguration = externalSourceConfiguration != null ? externalSourceConfiguration.build() : null;
        }

        @Override
        public final Builder externalSourceConfiguration(ExternalSourceConfiguration externalSourceConfiguration) {
            this.externalSourceConfiguration = externalSourceConfiguration;
            return this;
        }

        public final String getImportJobType() {
            return this.importJobType;
        }

        public final void setImportJobType(String importJobType) {
            this.importJobType = importJobType;
        }

        @Override
        public final Builder importJobType(String importJobType) {
            this.importJobType = importJobType;
            return this;
        }

        @Override
        public final Builder importJobType(ImportJobType importJobType) {
            this.importJobType(importJobType == null ? null : importJobType.toString());
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
            return this;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImportJobRequest build() {
            return new StartImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WisdomRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartImportJobRequest> {
        public Builder clientToken(String var1);

        public Builder externalSourceConfiguration(ExternalSourceConfiguration var1);

        default public Builder externalSourceConfiguration(Consumer<ExternalSourceConfiguration.Builder> externalSourceConfiguration) {
            return this.externalSourceConfiguration((ExternalSourceConfiguration)((ExternalSourceConfiguration.Builder)ExternalSourceConfiguration.builder().applyMutation(externalSourceConfiguration)).build());
        }

        public Builder importJobType(String var1);

        public Builder importJobType(ImportJobType var1);

        public Builder knowledgeBaseId(String var1);

        public Builder metadata(Map<String, String> var1);

        public Builder uploadId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

