/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wisdom.model.Document;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResultData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResultData> {
    private static final SdkField<Document> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("document").getter(ResultData.getter(ResultData::document)).setter(ResultData.setter(Builder::document)).constructor(Document::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()}).build();
    private static final SdkField<Double> RELEVANCE_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("relevanceScore").getter(ResultData.getter(ResultData::relevanceScore)).setter(ResultData.setter(Builder::relevanceScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceScore").build()}).build();
    private static final SdkField<String> RESULT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resultId").getter(ResultData.getter(ResultData::resultId)).setter(ResultData.setter(Builder::resultId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD, RELEVANCE_SCORE_FIELD, RESULT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResultData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Document document;
    private final Double relevanceScore;
    private final String resultId;

    private ResultData(BuilderImpl builder) {
        this.document = builder.document;
        this.relevanceScore = builder.relevanceScore;
        this.resultId = builder.resultId;
    }

    public final Document document() {
        return this.document;
    }

    public final Double relevanceScore() {
        return this.relevanceScore;
    }

    public final String resultId() {
        return this.resultId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.relevanceScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultData)) {
            return false;
        }
        ResultData other = (ResultData)obj;
        return Objects.equals(this.document(), other.document()) && Objects.equals(this.relevanceScore(), other.relevanceScore()) && Objects.equals(this.resultId(), other.resultId());
    }

    public final String toString() {
        return ToString.builder((String)"ResultData").add("Document", (Object)this.document()).add("RelevanceScore", (Object)this.relevanceScore()).add("ResultId", (Object)this.resultId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
            case "relevanceScore": {
                return Optional.ofNullable(clazz.cast(this.relevanceScore()));
            }
            case "resultId": {
                return Optional.ofNullable(clazz.cast(this.resultId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("document", DOCUMENT_FIELD);
        map.put("relevanceScore", RELEVANCE_SCORE_FIELD);
        map.put("resultId", RESULT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResultData, T> g) {
        return obj -> g.apply((ResultData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Document document;
        private Double relevanceScore;
        private String resultId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultData model) {
            this.document(model.document);
            this.relevanceScore(model.relevanceScore);
            this.resultId(model.resultId);
        }

        public final Document.Builder getDocument() {
            return this.document != null ? this.document.toBuilder() : null;
        }

        public final void setDocument(Document.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public final Builder document(Document document) {
            this.document = document;
            return this;
        }

        public final Double getRelevanceScore() {
            return this.relevanceScore;
        }

        public final void setRelevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
        }

        @Override
        public final Builder relevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
            return this;
        }

        public final String getResultId() {
            return this.resultId;
        }

        public final void setResultId(String resultId) {
            this.resultId = resultId;
        }

        @Override
        public final Builder resultId(String resultId) {
            this.resultId = resultId;
            return this;
        }

        public ResultData build() {
            return new ResultData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResultData> {
        public Builder document(Document var1);

        default public Builder document(Consumer<Document.Builder> document) {
            return this.document((Document)((Document.Builder)Document.builder().applyMutation(document)).build());
        }

        public Builder relevanceScore(Double var1);

        public Builder resultId(String var1);
    }
}

