/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wisdom.WisdomAsyncClient;
import software.amazon.awssdk.services.wisdom.internal.UserAgentUtils;
import software.amazon.awssdk.services.wisdom.model.QuickResponseSearchResultData;
import software.amazon.awssdk.services.wisdom.model.SearchQuickResponsesRequest;
import software.amazon.awssdk.services.wisdom.model.SearchQuickResponsesResponse;

public class SearchQuickResponsesPublisher
implements SdkPublisher<SearchQuickResponsesResponse> {
    private final WisdomAsyncClient client;
    private final SearchQuickResponsesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchQuickResponsesPublisher(WisdomAsyncClient client, SearchQuickResponsesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchQuickResponsesPublisher(WisdomAsyncClient client, SearchQuickResponsesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchQuickResponsesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchQuickResponsesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<QuickResponseSearchResultData> results() {
        Function<SearchQuickResponsesResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchQuickResponsesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchQuickResponsesResponseFetcher
    implements AsyncPageFetcher<SearchQuickResponsesResponse> {
        private SearchQuickResponsesResponseFetcher() {
        }

        public boolean hasNextPage(SearchQuickResponsesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchQuickResponsesResponse> nextPage(SearchQuickResponsesResponse previousPage) {
            if (previousPage == null) {
                return SearchQuickResponsesPublisher.this.client.searchQuickResponses(SearchQuickResponsesPublisher.this.firstRequest);
            }
            return SearchQuickResponsesPublisher.this.client.searchQuickResponses((SearchQuickResponsesRequest)((Object)SearchQuickResponsesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

