/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wisdom.model.ContentMetadataCopier;
import software.amazon.awssdk.services.wisdom.model.WisdomRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateContentRequest
extends WisdomRequest
implements ToCopyableBuilder<Builder, UpdateContentRequest> {
    private static final SdkField<String> CONTENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentId").getter(UpdateContentRequest.getter(UpdateContentRequest::contentId)).setter(UpdateContentRequest.setter(Builder::contentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("contentId").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(UpdateContentRequest.getter(UpdateContentRequest::knowledgeBaseId)).setter(UpdateContentRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metadata").getter(UpdateContentRequest.getter(UpdateContentRequest::metadata)).setter(UpdateContentRequest.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> OVERRIDE_LINK_OUT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("overrideLinkOutUri").getter(UpdateContentRequest.getter(UpdateContentRequest::overrideLinkOutUri)).setter(UpdateContentRequest.setter(Builder::overrideLinkOutUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideLinkOutUri").build()}).build();
    private static final SdkField<Boolean> REMOVE_OVERRIDE_LINK_OUT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("removeOverrideLinkOutUri").getter(UpdateContentRequest.getter(UpdateContentRequest::removeOverrideLinkOutUri)).setter(UpdateContentRequest.setter(Builder::removeOverrideLinkOutUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeOverrideLinkOutUri").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(UpdateContentRequest.getter(UpdateContentRequest::revisionId)).setter(UpdateContentRequest.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(UpdateContentRequest.getter(UpdateContentRequest::title)).setter(UpdateContentRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadId").getter(UpdateContentRequest.getter(UpdateContentRequest::uploadId)).setter(UpdateContentRequest.setter(Builder::uploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_ID_FIELD, KNOWLEDGE_BASE_ID_FIELD, METADATA_FIELD, OVERRIDE_LINK_OUT_URI_FIELD, REMOVE_OVERRIDE_LINK_OUT_URI_FIELD, REVISION_ID_FIELD, TITLE_FIELD, UPLOAD_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("contentId", CONTENT_ID_FIELD);
            this.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
            this.put("metadata", METADATA_FIELD);
            this.put("overrideLinkOutUri", OVERRIDE_LINK_OUT_URI_FIELD);
            this.put("removeOverrideLinkOutUri", REMOVE_OVERRIDE_LINK_OUT_URI_FIELD);
            this.put("revisionId", REVISION_ID_FIELD);
            this.put("title", TITLE_FIELD);
            this.put("uploadId", UPLOAD_ID_FIELD);
        }
    });
    private final String contentId;
    private final String knowledgeBaseId;
    private final Map<String, String> metadata;
    private final String overrideLinkOutUri;
    private final Boolean removeOverrideLinkOutUri;
    private final String revisionId;
    private final String title;
    private final String uploadId;

    private UpdateContentRequest(BuilderImpl builder) {
        super(builder);
        this.contentId = builder.contentId;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.metadata = builder.metadata;
        this.overrideLinkOutUri = builder.overrideLinkOutUri;
        this.removeOverrideLinkOutUri = builder.removeOverrideLinkOutUri;
        this.revisionId = builder.revisionId;
        this.title = builder.title;
        this.uploadId = builder.uploadId;
    }

    public final String contentId() {
        return this.contentId;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public final String overrideLinkOutUri() {
        return this.overrideLinkOutUri;
    }

    public final Boolean removeOverrideLinkOutUri() {
        return this.removeOverrideLinkOutUri;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final String title() {
        return this.title;
    }

    public final String uploadId() {
        return this.uploadId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideLinkOutUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeOverrideLinkOutUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContentRequest)) {
            return false;
        }
        UpdateContentRequest other = (UpdateContentRequest)((Object)obj);
        return Objects.equals(this.contentId(), other.contentId()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.overrideLinkOutUri(), other.overrideLinkOutUri()) && Objects.equals(this.removeOverrideLinkOutUri(), other.removeOverrideLinkOutUri()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.uploadId(), other.uploadId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateContentRequest").add("ContentId", (Object)this.contentId()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("Metadata", this.hasMetadata() ? this.metadata() : null).add("OverrideLinkOutUri", (Object)this.overrideLinkOutUri()).add("RemoveOverrideLinkOutUri", (Object)this.removeOverrideLinkOutUri()).add("RevisionId", (Object)this.revisionId()).add("Title", (Object)this.title()).add("UploadId", (Object)this.uploadId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentId": {
                return Optional.ofNullable(clazz.cast(this.contentId()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "overrideLinkOutUri": {
                return Optional.ofNullable(clazz.cast(this.overrideLinkOutUri()));
            }
            case "removeOverrideLinkOutUri": {
                return Optional.ofNullable(clazz.cast(this.removeOverrideLinkOutUri()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "uploadId": {
                return Optional.ofNullable(clazz.cast(this.uploadId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContentRequest, T> g) {
        return obj -> g.apply((UpdateContentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WisdomRequest.BuilderImpl
    implements Builder {
        private String contentId;
        private String knowledgeBaseId;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();
        private String overrideLinkOutUri;
        private Boolean removeOverrideLinkOutUri;
        private String revisionId;
        private String title;
        private String uploadId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContentRequest model) {
            super(model);
            this.contentId(model.contentId);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.metadata(model.metadata);
            this.overrideLinkOutUri(model.overrideLinkOutUri);
            this.removeOverrideLinkOutUri(model.removeOverrideLinkOutUri);
            this.revisionId(model.revisionId);
            this.title(model.title);
            this.uploadId(model.uploadId);
        }

        public final String getContentId() {
            return this.contentId;
        }

        public final void setContentId(String contentId) {
            this.contentId = contentId;
        }

        @Override
        public final Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
            return this;
        }

        public final String getOverrideLinkOutUri() {
            return this.overrideLinkOutUri;
        }

        public final void setOverrideLinkOutUri(String overrideLinkOutUri) {
            this.overrideLinkOutUri = overrideLinkOutUri;
        }

        @Override
        public final Builder overrideLinkOutUri(String overrideLinkOutUri) {
            this.overrideLinkOutUri = overrideLinkOutUri;
            return this;
        }

        public final Boolean getRemoveOverrideLinkOutUri() {
            return this.removeOverrideLinkOutUri;
        }

        public final void setRemoveOverrideLinkOutUri(Boolean removeOverrideLinkOutUri) {
            this.removeOverrideLinkOutUri = removeOverrideLinkOutUri;
        }

        @Override
        public final Builder removeOverrideLinkOutUri(Boolean removeOverrideLinkOutUri) {
            this.removeOverrideLinkOutUri = removeOverrideLinkOutUri;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContentRequest build() {
            return new UpdateContentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WisdomRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateContentRequest> {
        public Builder contentId(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder metadata(Map<String, String> var1);

        public Builder overrideLinkOutUri(String var1);

        public Builder removeOverrideLinkOutUri(Boolean var1);

        public Builder revisionId(String var1);

        public Builder title(String var1);

        public Builder uploadId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

