/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wisdom.model.SearchExpression;
import software.amazon.awssdk.services.wisdom.model.WisdomRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchSessionsRequest
extends WisdomRequest
implements ToCopyableBuilder<Builder, SearchSessionsRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(SearchSessionsRequest.getter(SearchSessionsRequest::assistantId)).setter(SearchSessionsRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(SearchSessionsRequest.getter(SearchSessionsRequest::maxResults)).setter(SearchSessionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchSessionsRequest.getter(SearchSessionsRequest::nextToken)).setter(SearchSessionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<SearchExpression> SEARCH_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("searchExpression").getter(SearchSessionsRequest.getter(SearchSessionsRequest::searchExpression)).setter(SearchSessionsRequest.setter(Builder::searchExpression)).constructor(SearchExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchExpression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SEARCH_EXPRESSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("assistantId", ASSISTANT_ID_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("searchExpression", SEARCH_EXPRESSION_FIELD);
        }
    });
    private final String assistantId;
    private final Integer maxResults;
    private final String nextToken;
    private final SearchExpression searchExpression;

    private SearchSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.searchExpression = builder.searchExpression;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final SearchExpression searchExpression() {
        return this.searchExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchExpression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSessionsRequest)) {
            return false;
        }
        SearchSessionsRequest other = (SearchSessionsRequest)((Object)obj);
        return Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.searchExpression(), other.searchExpression());
    }

    public final String toString() {
        return ToString.builder((String)"SearchSessionsRequest").add("AssistantId", (Object)this.assistantId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SearchExpression", (Object)this.searchExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "searchExpression": {
                return Optional.ofNullable(clazz.cast(this.searchExpression()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchSessionsRequest, T> g) {
        return obj -> g.apply((SearchSessionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WisdomRequest.BuilderImpl
    implements Builder {
        private String assistantId;
        private Integer maxResults;
        private String nextToken;
        private SearchExpression searchExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSessionsRequest model) {
            super(model);
            this.assistantId(model.assistantId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.searchExpression(model.searchExpression);
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final SearchExpression.Builder getSearchExpression() {
            return this.searchExpression != null ? this.searchExpression.toBuilder() : null;
        }

        public final void setSearchExpression(SearchExpression.BuilderImpl searchExpression) {
            this.searchExpression = searchExpression != null ? searchExpression.build() : null;
        }

        @Override
        public final Builder searchExpression(SearchExpression searchExpression) {
            this.searchExpression = searchExpression;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchSessionsRequest build() {
            return new SearchSessionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WisdomRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchSessionsRequest> {
        public Builder assistantId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder searchExpression(SearchExpression var1);

        default public Builder searchExpression(Consumer<SearchExpression.Builder> searchExpression) {
            return this.searchExpression((SearchExpression)((SearchExpression.Builder)SearchExpression.builder().applyMutation(searchExpression)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

