/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wisdom.WisdomClient;
import software.amazon.awssdk.services.wisdom.internal.UserAgentUtils;
import software.amazon.awssdk.services.wisdom.model.KnowledgeBaseSummary;
import software.amazon.awssdk.services.wisdom.model.ListKnowledgeBasesRequest;
import software.amazon.awssdk.services.wisdom.model.ListKnowledgeBasesResponse;

public class ListKnowledgeBasesIterable
implements SdkIterable<ListKnowledgeBasesResponse> {
    private final WisdomClient client;
    private final ListKnowledgeBasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKnowledgeBasesIterable(WisdomClient client, ListKnowledgeBasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListKnowledgeBasesResponseFetcher();
    }

    public Iterator<ListKnowledgeBasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<KnowledgeBaseSummary> knowledgeBaseSummaries() {
        Function<ListKnowledgeBasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.knowledgeBaseSummaries() != null) {
                return response.knowledgeBaseSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListKnowledgeBasesResponseFetcher
    implements SyncPageFetcher<ListKnowledgeBasesResponse> {
        private ListKnowledgeBasesResponseFetcher() {
        }

        public boolean hasNextPage(ListKnowledgeBasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListKnowledgeBasesResponse nextPage(ListKnowledgeBasesResponse previousPage) {
            if (previousPage == null) {
                return ListKnowledgeBasesIterable.this.client.listKnowledgeBases(ListKnowledgeBasesIterable.this.firstRequest);
            }
            return ListKnowledgeBasesIterable.this.client.listKnowledgeBases((ListKnowledgeBasesRequest)((Object)ListKnowledgeBasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

