/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wisdom.WisdomClient;
import software.amazon.awssdk.services.wisdom.model.ContentSummary;
import software.amazon.awssdk.services.wisdom.model.SearchContentRequest;
import software.amazon.awssdk.services.wisdom.model.SearchContentResponse;

public class SearchContentIterable
implements SdkIterable<SearchContentResponse> {
    private final WisdomClient client;
    private final SearchContentRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchContentIterable(WisdomClient client, SearchContentRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchContentResponseFetcher();
    }

    public Iterator<SearchContentResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContentSummary> contentSummaries() {
        Function<SearchContentResponse, Iterator> getIterator = response -> {
            if (response != null && response.contentSummaries() != null) {
                return response.contentSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchContentResponseFetcher
    implements SyncPageFetcher<SearchContentResponse> {
        private SearchContentResponseFetcher() {
        }

        public boolean hasNextPage(SearchContentResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchContentResponse nextPage(SearchContentResponse previousPage) {
            if (previousPage == null) {
                return SearchContentIterable.this.client.searchContent(SearchContentIterable.this.firstRequest);
            }
            return SearchContentIterable.this.client.searchContent((SearchContentRequest)((Object)SearchContentIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

