/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.wisdom.DefaultWisdomAsyncClient;
import software.amazon.awssdk.services.wisdom.DefaultWisdomBaseClientBuilder;
import software.amazon.awssdk.services.wisdom.WisdomAsyncClient;
import software.amazon.awssdk.services.wisdom.WisdomAsyncClientBuilder;
import software.amazon.awssdk.services.wisdom.WisdomServiceClientConfiguration;
import software.amazon.awssdk.services.wisdom.endpoints.WisdomEndpointProvider;

@SdkInternalApi
final class DefaultWisdomAsyncClientBuilder
extends DefaultWisdomBaseClientBuilder<WisdomAsyncClientBuilder, WisdomAsyncClient>
implements WisdomAsyncClientBuilder {
    DefaultWisdomAsyncClientBuilder() {
    }

    @Override
    public DefaultWisdomAsyncClientBuilder endpointProvider(WisdomEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WisdomAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultWisdomAsyncClientBuilder.validateClientOptions(clientConfiguration);
        WisdomServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultWisdomAsyncClient client = new DefaultWisdomAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private WisdomServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return WisdomServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

