/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wisdom.WisdomAsyncClient;
import software.amazon.awssdk.services.wisdom.model.ContentSummary;
import software.amazon.awssdk.services.wisdom.model.SearchContentRequest;
import software.amazon.awssdk.services.wisdom.model.SearchContentResponse;

public class SearchContentPublisher
implements SdkPublisher<SearchContentResponse> {
    private final WisdomAsyncClient client;
    private final SearchContentRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchContentPublisher(WisdomAsyncClient client, SearchContentRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchContentPublisher(WisdomAsyncClient client, SearchContentRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchContentResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchContentResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContentSummary> contentSummaries() {
        Function<SearchContentResponse, Iterator> getIterator = response -> {
            if (response != null && response.contentSummaries() != null) {
                return response.contentSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchContentResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchContentResponseFetcher
    implements AsyncPageFetcher<SearchContentResponse> {
        private SearchContentResponseFetcher() {
        }

        public boolean hasNextPage(SearchContentResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchContentResponse> nextPage(SearchContentResponse previousPage) {
            if (previousPage == null) {
                return SearchContentPublisher.this.client.searchContent(SearchContentPublisher.this.firstRequest);
            }
            return SearchContentPublisher.this.client.searchContent((SearchContentRequest)((Object)SearchContentPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

