/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wisdom.model.AssistantListCopier;
import software.amazon.awssdk.services.wisdom.model.AssistantSummary;
import software.amazon.awssdk.services.wisdom.model.WisdomResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssistantsResponse
extends WisdomResponse
implements ToCopyableBuilder<Builder, ListAssistantsResponse> {
    private static final SdkField<List<AssistantSummary>> ASSISTANT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assistantSummaries").getter(ListAssistantsResponse.getter(ListAssistantsResponse::assistantSummaries)).setter(ListAssistantsResponse.setter(Builder::assistantSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssistantSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssistantsResponse.getter(ListAssistantsResponse::nextToken)).setter(ListAssistantsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AssistantSummary> assistantSummaries;
    private final String nextToken;

    private ListAssistantsResponse(BuilderImpl builder) {
        super(builder);
        this.assistantSummaries = builder.assistantSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssistantSummaries() {
        return this.assistantSummaries != null && !(this.assistantSummaries instanceof SdkAutoConstructList);
    }

    public final List<AssistantSummary> assistantSummaries() {
        return this.assistantSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssistantSummaries() ? this.assistantSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssistantsResponse)) {
            return false;
        }
        ListAssistantsResponse other = (ListAssistantsResponse)((Object)obj);
        return this.hasAssistantSummaries() == other.hasAssistantSummaries() && Objects.equals(this.assistantSummaries(), other.assistantSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssistantsResponse").add("AssistantSummaries", this.hasAssistantSummaries() ? this.assistantSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantSummaries": {
                return Optional.ofNullable(clazz.cast(this.assistantSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssistantsResponse, T> g) {
        return obj -> g.apply((ListAssistantsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WisdomResponse.BuilderImpl
    implements Builder {
        private List<AssistantSummary> assistantSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssistantsResponse model) {
            super(model);
            this.assistantSummaries(model.assistantSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AssistantSummary.Builder> getAssistantSummaries() {
            List<AssistantSummary.Builder> result = AssistantListCopier.copyToBuilder(this.assistantSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssistantSummaries(Collection<AssistantSummary.BuilderImpl> assistantSummaries) {
            this.assistantSummaries = AssistantListCopier.copyFromBuilder(assistantSummaries);
        }

        @Override
        @Transient
        public final Builder assistantSummaries(Collection<AssistantSummary> assistantSummaries) {
            this.assistantSummaries = AssistantListCopier.copy(assistantSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assistantSummaries(AssistantSummary ... assistantSummaries) {
            this.assistantSummaries(Arrays.asList(assistantSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assistantSummaries(Consumer<AssistantSummary.Builder> ... assistantSummaries) {
            this.assistantSummaries(Stream.of(assistantSummaries).map(c -> (AssistantSummary)((AssistantSummary.Builder)AssistantSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssistantsResponse build() {
            return new ListAssistantsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WisdomResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssistantsResponse> {
        public Builder assistantSummaries(Collection<AssistantSummary> var1);

        public Builder assistantSummaries(AssistantSummary ... var1);

        public Builder assistantSummaries(Consumer<AssistantSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

