/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wickr.model.CallingSettings;
import software.amazon.awssdk.services.wickr.model.PasswordRequirements;
import software.amazon.awssdk.services.wickr.model.PermittedNetworksListCopier;
import software.amazon.awssdk.services.wickr.model.PermittedWickrEnterpriseNetwork;
import software.amazon.awssdk.services.wickr.model.PermittedWickrEnterpriseNetworksListCopier;
import software.amazon.awssdk.services.wickr.model.SecurityGroupStringListCopier;
import software.amazon.awssdk.services.wickr.model.ShredderSettings;
import software.amazon.awssdk.services.wickr.model.WickrAwsNetworks;
import software.amazon.awssdk.services.wickr.model.WickrAwsNetworksListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityGroupSettings> {
    private static final SdkField<Boolean> ALWAYS_REAUTHENTICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("alwaysReauthenticate").getter(SecurityGroupSettings.getter(SecurityGroupSettings::alwaysReauthenticate)).setter(SecurityGroupSettings.setter(Builder::alwaysReauthenticate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alwaysReauthenticate").build()}).build();
    private static final SdkField<List<String>> ATAK_PACKAGE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("atakPackageValues").getter(SecurityGroupSettings.getter(SecurityGroupSettings::atakPackageValues)).setter(SecurityGroupSettings.setter(Builder::atakPackageValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("atakPackageValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CallingSettings> CALLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("calling").getter(SecurityGroupSettings.getter(SecurityGroupSettings::calling)).setter(SecurityGroupSettings.setter(Builder::calling)).constructor(CallingSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("calling").build()}).build();
    private static final SdkField<Boolean> CHECK_FOR_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("checkForUpdates").getter(SecurityGroupSettings.getter(SecurityGroupSettings::checkForUpdates)).setter(SecurityGroupSettings.setter(Builder::checkForUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkForUpdates").build()}).build();
    private static final SdkField<Boolean> ENABLE_ATAK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableAtak").getter(SecurityGroupSettings.getter(SecurityGroupSettings::enableAtak)).setter(SecurityGroupSettings.setter(Builder::enableAtak)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAtak").build()}).build();
    private static final SdkField<Boolean> ENABLE_CRASH_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableCrashReports").getter(SecurityGroupSettings.getter(SecurityGroupSettings::enableCrashReports)).setter(SecurityGroupSettings.setter(Builder::enableCrashReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableCrashReports").build()}).build();
    private static final SdkField<Boolean> ENABLE_FILE_DOWNLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableFileDownload").getter(SecurityGroupSettings.getter(SecurityGroupSettings::enableFileDownload)).setter(SecurityGroupSettings.setter(Builder::enableFileDownload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableFileDownload").build()}).build();
    private static final SdkField<Boolean> ENABLE_GUEST_FEDERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableGuestFederation").getter(SecurityGroupSettings.getter(SecurityGroupSettings::enableGuestFederation)).setter(SecurityGroupSettings.setter(Builder::enableGuestFederation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableGuestFederation").build()}).build();
    private static final SdkField<Boolean> ENABLE_NOTIFICATION_PREVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableNotificationPreview").getter(SecurityGroupSettings.getter(SecurityGroupSettings::enableNotificationPreview)).setter(SecurityGroupSettings.setter(Builder::enableNotificationPreview)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableNotificationPreview").build()}).build();
    private static final SdkField<Boolean> ENABLE_OPEN_ACCESS_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableOpenAccessOption").getter(SecurityGroupSettings.getter(SecurityGroupSettings::enableOpenAccessOption)).setter(SecurityGroupSettings.setter(Builder::enableOpenAccessOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableOpenAccessOption").build()}).build();
    private static final SdkField<Boolean> ENABLE_RESTRICTED_GLOBAL_FEDERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableRestrictedGlobalFederation").getter(SecurityGroupSettings.getter(SecurityGroupSettings::enableRestrictedGlobalFederation)).setter(SecurityGroupSettings.setter(Builder::enableRestrictedGlobalFederation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableRestrictedGlobalFederation").build()}).build();
    private static final SdkField<Boolean> FILES_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("filesEnabled").getter(SecurityGroupSettings.getter(SecurityGroupSettings::filesEnabled)).setter(SecurityGroupSettings.setter(Builder::filesEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filesEnabled").build()}).build();
    private static final SdkField<Integer> FORCE_DEVICE_LOCKOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("forceDeviceLockout").getter(SecurityGroupSettings.getter(SecurityGroupSettings::forceDeviceLockout)).setter(SecurityGroupSettings.setter(Builder::forceDeviceLockout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceDeviceLockout").build()}).build();
    private static final SdkField<Boolean> FORCE_OPEN_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("forceOpenAccess").getter(SecurityGroupSettings.getter(SecurityGroupSettings::forceOpenAccess)).setter(SecurityGroupSettings.setter(Builder::forceOpenAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceOpenAccess").build()}).build();
    private static final SdkField<Boolean> FORCE_READ_RECEIPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("forceReadReceipts").getter(SecurityGroupSettings.getter(SecurityGroupSettings::forceReadReceipts)).setter(SecurityGroupSettings.setter(Builder::forceReadReceipts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceReadReceipts").build()}).build();
    private static final SdkField<Boolean> GLOBAL_FEDERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("globalFederation").getter(SecurityGroupSettings.getter(SecurityGroupSettings::globalFederation)).setter(SecurityGroupSettings.setter(Builder::globalFederation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalFederation").build()}).build();
    private static final SdkField<Boolean> IS_ATO_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isAtoEnabled").getter(SecurityGroupSettings.getter(SecurityGroupSettings::isAtoEnabled)).setter(SecurityGroupSettings.setter(Builder::isAtoEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAtoEnabled").build()}).build();
    private static final SdkField<Boolean> IS_LINK_PREVIEW_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isLinkPreviewEnabled").getter(SecurityGroupSettings.getter(SecurityGroupSettings::isLinkPreviewEnabled)).setter(SecurityGroupSettings.setter(Builder::isLinkPreviewEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isLinkPreviewEnabled").build()}).build();
    private static final SdkField<Boolean> LOCATION_ALLOW_MAPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("locationAllowMaps").getter(SecurityGroupSettings.getter(SecurityGroupSettings::locationAllowMaps)).setter(SecurityGroupSettings.setter(Builder::locationAllowMaps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationAllowMaps").build()}).build();
    private static final SdkField<Boolean> LOCATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("locationEnabled").getter(SecurityGroupSettings.getter(SecurityGroupSettings::locationEnabled)).setter(SecurityGroupSettings.setter(Builder::locationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationEnabled").build()}).build();
    private static final SdkField<Long> MAX_AUTO_DOWNLOAD_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("maxAutoDownloadSize").getter(SecurityGroupSettings.getter(SecurityGroupSettings::maxAutoDownloadSize)).setter(SecurityGroupSettings.setter(Builder::maxAutoDownloadSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAutoDownloadSize").build()}).build();
    private static final SdkField<Integer> MAX_BOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxBor").getter(SecurityGroupSettings.getter(SecurityGroupSettings::maxBor)).setter(SecurityGroupSettings.setter(Builder::maxBor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBor").build()}).build();
    private static final SdkField<Long> MAX_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("maxTtl").getter(SecurityGroupSettings.getter(SecurityGroupSettings::maxTtl)).setter(SecurityGroupSettings.setter(Builder::maxTtl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxTtl").build()}).build();
    private static final SdkField<Boolean> MESSAGE_FORWARDING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("messageForwardingEnabled").getter(SecurityGroupSettings.getter(SecurityGroupSettings::messageForwardingEnabled)).setter(SecurityGroupSettings.setter(Builder::messageForwardingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageForwardingEnabled").build()}).build();
    private static final SdkField<PasswordRequirements> PASSWORD_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("passwordRequirements").getter(SecurityGroupSettings.getter(SecurityGroupSettings::passwordRequirements)).setter(SecurityGroupSettings.setter(Builder::passwordRequirements)).constructor(PasswordRequirements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passwordRequirements").build()}).build();
    private static final SdkField<Boolean> PRESENCE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("presenceEnabled").getter(SecurityGroupSettings.getter(SecurityGroupSettings::presenceEnabled)).setter(SecurityGroupSettings.setter(Builder::presenceEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presenceEnabled").build()}).build();
    private static final SdkField<List<String>> QUICK_RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("quickResponses").getter(SecurityGroupSettings.getter(SecurityGroupSettings::quickResponses)).setter(SecurityGroupSettings.setter(Builder::quickResponses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quickResponses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SHOW_MASTER_RECOVERY_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("showMasterRecoveryKey").getter(SecurityGroupSettings.getter(SecurityGroupSettings::showMasterRecoveryKey)).setter(SecurityGroupSettings.setter(Builder::showMasterRecoveryKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("showMasterRecoveryKey").build()}).build();
    private static final SdkField<ShredderSettings> SHREDDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("shredder").getter(SecurityGroupSettings.getter(SecurityGroupSettings::shredder)).setter(SecurityGroupSettings.setter(Builder::shredder)).constructor(ShredderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shredder").build()}).build();
    private static final SdkField<Integer> SSO_MAX_IDLE_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ssoMaxIdleMinutes").getter(SecurityGroupSettings.getter(SecurityGroupSettings::ssoMaxIdleMinutes)).setter(SecurityGroupSettings.setter(Builder::ssoMaxIdleMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssoMaxIdleMinutes").build()}).build();
    private static final SdkField<Integer> FEDERATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("federationMode").getter(SecurityGroupSettings.getter(SecurityGroupSettings::federationMode)).setter(SecurityGroupSettings.setter(Builder::federationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationMode").build()}).build();
    private static final SdkField<Integer> LOCKOUT_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("lockoutThreshold").getter(SecurityGroupSettings.getter(SecurityGroupSettings::lockoutThreshold)).setter(SecurityGroupSettings.setter(Builder::lockoutThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lockoutThreshold").build()}).build();
    private static final SdkField<List<String>> PERMITTED_NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("permittedNetworks").getter(SecurityGroupSettings.getter(SecurityGroupSettings::permittedNetworks)).setter(SecurityGroupSettings.setter(Builder::permittedNetworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permittedNetworks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<WickrAwsNetworks>> PERMITTED_WICKR_AWS_NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("permittedWickrAwsNetworks").getter(SecurityGroupSettings.getter(SecurityGroupSettings::permittedWickrAwsNetworks)).setter(SecurityGroupSettings.setter(Builder::permittedWickrAwsNetworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permittedWickrAwsNetworks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WickrAwsNetworks::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PermittedWickrEnterpriseNetwork>> PERMITTED_WICKR_ENTERPRISE_NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("permittedWickrEnterpriseNetworks").getter(SecurityGroupSettings.getter(SecurityGroupSettings::permittedWickrEnterpriseNetworks)).setter(SecurityGroupSettings.setter(Builder::permittedWickrEnterpriseNetworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permittedWickrEnterpriseNetworks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PermittedWickrEnterpriseNetwork::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALWAYS_REAUTHENTICATE_FIELD, ATAK_PACKAGE_VALUES_FIELD, CALLING_FIELD, CHECK_FOR_UPDATES_FIELD, ENABLE_ATAK_FIELD, ENABLE_CRASH_REPORTS_FIELD, ENABLE_FILE_DOWNLOAD_FIELD, ENABLE_GUEST_FEDERATION_FIELD, ENABLE_NOTIFICATION_PREVIEW_FIELD, ENABLE_OPEN_ACCESS_OPTION_FIELD, ENABLE_RESTRICTED_GLOBAL_FEDERATION_FIELD, FILES_ENABLED_FIELD, FORCE_DEVICE_LOCKOUT_FIELD, FORCE_OPEN_ACCESS_FIELD, FORCE_READ_RECEIPTS_FIELD, GLOBAL_FEDERATION_FIELD, IS_ATO_ENABLED_FIELD, IS_LINK_PREVIEW_ENABLED_FIELD, LOCATION_ALLOW_MAPS_FIELD, LOCATION_ENABLED_FIELD, MAX_AUTO_DOWNLOAD_SIZE_FIELD, MAX_BOR_FIELD, MAX_TTL_FIELD, MESSAGE_FORWARDING_ENABLED_FIELD, PASSWORD_REQUIREMENTS_FIELD, PRESENCE_ENABLED_FIELD, QUICK_RESPONSES_FIELD, SHOW_MASTER_RECOVERY_KEY_FIELD, SHREDDER_FIELD, SSO_MAX_IDLE_MINUTES_FIELD, FEDERATION_MODE_FIELD, LOCKOUT_THRESHOLD_FIELD, PERMITTED_NETWORKS_FIELD, PERMITTED_WICKR_AWS_NETWORKS_FIELD, PERMITTED_WICKR_ENTERPRISE_NETWORKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SecurityGroupSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean alwaysReauthenticate;
    private final List<String> atakPackageValues;
    private final CallingSettings calling;
    private final Boolean checkForUpdates;
    private final Boolean enableAtak;
    private final Boolean enableCrashReports;
    private final Boolean enableFileDownload;
    private final Boolean enableGuestFederation;
    private final Boolean enableNotificationPreview;
    private final Boolean enableOpenAccessOption;
    private final Boolean enableRestrictedGlobalFederation;
    private final Boolean filesEnabled;
    private final Integer forceDeviceLockout;
    private final Boolean forceOpenAccess;
    private final Boolean forceReadReceipts;
    private final Boolean globalFederation;
    private final Boolean isAtoEnabled;
    private final Boolean isLinkPreviewEnabled;
    private final Boolean locationAllowMaps;
    private final Boolean locationEnabled;
    private final Long maxAutoDownloadSize;
    private final Integer maxBor;
    private final Long maxTtl;
    private final Boolean messageForwardingEnabled;
    private final PasswordRequirements passwordRequirements;
    private final Boolean presenceEnabled;
    private final List<String> quickResponses;
    private final Boolean showMasterRecoveryKey;
    private final ShredderSettings shredder;
    private final Integer ssoMaxIdleMinutes;
    private final Integer federationMode;
    private final Integer lockoutThreshold;
    private final List<String> permittedNetworks;
    private final List<WickrAwsNetworks> permittedWickrAwsNetworks;
    private final List<PermittedWickrEnterpriseNetwork> permittedWickrEnterpriseNetworks;

    private SecurityGroupSettings(BuilderImpl builder) {
        this.alwaysReauthenticate = builder.alwaysReauthenticate;
        this.atakPackageValues = builder.atakPackageValues;
        this.calling = builder.calling;
        this.checkForUpdates = builder.checkForUpdates;
        this.enableAtak = builder.enableAtak;
        this.enableCrashReports = builder.enableCrashReports;
        this.enableFileDownload = builder.enableFileDownload;
        this.enableGuestFederation = builder.enableGuestFederation;
        this.enableNotificationPreview = builder.enableNotificationPreview;
        this.enableOpenAccessOption = builder.enableOpenAccessOption;
        this.enableRestrictedGlobalFederation = builder.enableRestrictedGlobalFederation;
        this.filesEnabled = builder.filesEnabled;
        this.forceDeviceLockout = builder.forceDeviceLockout;
        this.forceOpenAccess = builder.forceOpenAccess;
        this.forceReadReceipts = builder.forceReadReceipts;
        this.globalFederation = builder.globalFederation;
        this.isAtoEnabled = builder.isAtoEnabled;
        this.isLinkPreviewEnabled = builder.isLinkPreviewEnabled;
        this.locationAllowMaps = builder.locationAllowMaps;
        this.locationEnabled = builder.locationEnabled;
        this.maxAutoDownloadSize = builder.maxAutoDownloadSize;
        this.maxBor = builder.maxBor;
        this.maxTtl = builder.maxTtl;
        this.messageForwardingEnabled = builder.messageForwardingEnabled;
        this.passwordRequirements = builder.passwordRequirements;
        this.presenceEnabled = builder.presenceEnabled;
        this.quickResponses = builder.quickResponses;
        this.showMasterRecoveryKey = builder.showMasterRecoveryKey;
        this.shredder = builder.shredder;
        this.ssoMaxIdleMinutes = builder.ssoMaxIdleMinutes;
        this.federationMode = builder.federationMode;
        this.lockoutThreshold = builder.lockoutThreshold;
        this.permittedNetworks = builder.permittedNetworks;
        this.permittedWickrAwsNetworks = builder.permittedWickrAwsNetworks;
        this.permittedWickrEnterpriseNetworks = builder.permittedWickrEnterpriseNetworks;
    }

    public final Boolean alwaysReauthenticate() {
        return this.alwaysReauthenticate;
    }

    public final boolean hasAtakPackageValues() {
        return this.atakPackageValues != null && !(this.atakPackageValues instanceof SdkAutoConstructList);
    }

    public final List<String> atakPackageValues() {
        return this.atakPackageValues;
    }

    public final CallingSettings calling() {
        return this.calling;
    }

    public final Boolean checkForUpdates() {
        return this.checkForUpdates;
    }

    public final Boolean enableAtak() {
        return this.enableAtak;
    }

    public final Boolean enableCrashReports() {
        return this.enableCrashReports;
    }

    public final Boolean enableFileDownload() {
        return this.enableFileDownload;
    }

    public final Boolean enableGuestFederation() {
        return this.enableGuestFederation;
    }

    public final Boolean enableNotificationPreview() {
        return this.enableNotificationPreview;
    }

    public final Boolean enableOpenAccessOption() {
        return this.enableOpenAccessOption;
    }

    public final Boolean enableRestrictedGlobalFederation() {
        return this.enableRestrictedGlobalFederation;
    }

    public final Boolean filesEnabled() {
        return this.filesEnabled;
    }

    public final Integer forceDeviceLockout() {
        return this.forceDeviceLockout;
    }

    public final Boolean forceOpenAccess() {
        return this.forceOpenAccess;
    }

    public final Boolean forceReadReceipts() {
        return this.forceReadReceipts;
    }

    public final Boolean globalFederation() {
        return this.globalFederation;
    }

    public final Boolean isAtoEnabled() {
        return this.isAtoEnabled;
    }

    public final Boolean isLinkPreviewEnabled() {
        return this.isLinkPreviewEnabled;
    }

    public final Boolean locationAllowMaps() {
        return this.locationAllowMaps;
    }

    public final Boolean locationEnabled() {
        return this.locationEnabled;
    }

    public final Long maxAutoDownloadSize() {
        return this.maxAutoDownloadSize;
    }

    public final Integer maxBor() {
        return this.maxBor;
    }

    public final Long maxTtl() {
        return this.maxTtl;
    }

    public final Boolean messageForwardingEnabled() {
        return this.messageForwardingEnabled;
    }

    public final PasswordRequirements passwordRequirements() {
        return this.passwordRequirements;
    }

    public final Boolean presenceEnabled() {
        return this.presenceEnabled;
    }

    public final boolean hasQuickResponses() {
        return this.quickResponses != null && !(this.quickResponses instanceof SdkAutoConstructList);
    }

    public final List<String> quickResponses() {
        return this.quickResponses;
    }

    public final Boolean showMasterRecoveryKey() {
        return this.showMasterRecoveryKey;
    }

    public final ShredderSettings shredder() {
        return this.shredder;
    }

    public final Integer ssoMaxIdleMinutes() {
        return this.ssoMaxIdleMinutes;
    }

    public final Integer federationMode() {
        return this.federationMode;
    }

    public final Integer lockoutThreshold() {
        return this.lockoutThreshold;
    }

    public final boolean hasPermittedNetworks() {
        return this.permittedNetworks != null && !(this.permittedNetworks instanceof SdkAutoConstructList);
    }

    public final List<String> permittedNetworks() {
        return this.permittedNetworks;
    }

    public final boolean hasPermittedWickrAwsNetworks() {
        return this.permittedWickrAwsNetworks != null && !(this.permittedWickrAwsNetworks instanceof SdkAutoConstructList);
    }

    public final List<WickrAwsNetworks> permittedWickrAwsNetworks() {
        return this.permittedWickrAwsNetworks;
    }

    public final boolean hasPermittedWickrEnterpriseNetworks() {
        return this.permittedWickrEnterpriseNetworks != null && !(this.permittedWickrEnterpriseNetworks instanceof SdkAutoConstructList);
    }

    public final List<PermittedWickrEnterpriseNetwork> permittedWickrEnterpriseNetworks() {
        return this.permittedWickrEnterpriseNetworks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alwaysReauthenticate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAtakPackageValues() ? this.atakPackageValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.calling());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkForUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAtak());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableCrashReports());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableFileDownload());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableGuestFederation());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableNotificationPreview());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableOpenAccessOption());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableRestrictedGlobalFederation());
        hashCode = 31 * hashCode + Objects.hashCode(this.filesEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceDeviceLockout());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceOpenAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceReadReceipts());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalFederation());
        hashCode = 31 * hashCode + Objects.hashCode(this.isAtoEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.isLinkPreviewEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationAllowMaps());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAutoDownloadSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBor());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTtl());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageForwardingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(this.presenceEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuickResponses() ? this.quickResponses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.showMasterRecoveryKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.shredder());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssoMaxIdleMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.federationMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockoutThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermittedNetworks() ? this.permittedNetworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermittedWickrAwsNetworks() ? this.permittedWickrAwsNetworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermittedWickrEnterpriseNetworks() ? this.permittedWickrEnterpriseNetworks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupSettings)) {
            return false;
        }
        SecurityGroupSettings other = (SecurityGroupSettings)obj;
        return Objects.equals(this.alwaysReauthenticate(), other.alwaysReauthenticate()) && this.hasAtakPackageValues() == other.hasAtakPackageValues() && Objects.equals(this.atakPackageValues(), other.atakPackageValues()) && Objects.equals(this.calling(), other.calling()) && Objects.equals(this.checkForUpdates(), other.checkForUpdates()) && Objects.equals(this.enableAtak(), other.enableAtak()) && Objects.equals(this.enableCrashReports(), other.enableCrashReports()) && Objects.equals(this.enableFileDownload(), other.enableFileDownload()) && Objects.equals(this.enableGuestFederation(), other.enableGuestFederation()) && Objects.equals(this.enableNotificationPreview(), other.enableNotificationPreview()) && Objects.equals(this.enableOpenAccessOption(), other.enableOpenAccessOption()) && Objects.equals(this.enableRestrictedGlobalFederation(), other.enableRestrictedGlobalFederation()) && Objects.equals(this.filesEnabled(), other.filesEnabled()) && Objects.equals(this.forceDeviceLockout(), other.forceDeviceLockout()) && Objects.equals(this.forceOpenAccess(), other.forceOpenAccess()) && Objects.equals(this.forceReadReceipts(), other.forceReadReceipts()) && Objects.equals(this.globalFederation(), other.globalFederation()) && Objects.equals(this.isAtoEnabled(), other.isAtoEnabled()) && Objects.equals(this.isLinkPreviewEnabled(), other.isLinkPreviewEnabled()) && Objects.equals(this.locationAllowMaps(), other.locationAllowMaps()) && Objects.equals(this.locationEnabled(), other.locationEnabled()) && Objects.equals(this.maxAutoDownloadSize(), other.maxAutoDownloadSize()) && Objects.equals(this.maxBor(), other.maxBor()) && Objects.equals(this.maxTtl(), other.maxTtl()) && Objects.equals(this.messageForwardingEnabled(), other.messageForwardingEnabled()) && Objects.equals(this.passwordRequirements(), other.passwordRequirements()) && Objects.equals(this.presenceEnabled(), other.presenceEnabled()) && this.hasQuickResponses() == other.hasQuickResponses() && Objects.equals(this.quickResponses(), other.quickResponses()) && Objects.equals(this.showMasterRecoveryKey(), other.showMasterRecoveryKey()) && Objects.equals(this.shredder(), other.shredder()) && Objects.equals(this.ssoMaxIdleMinutes(), other.ssoMaxIdleMinutes()) && Objects.equals(this.federationMode(), other.federationMode()) && Objects.equals(this.lockoutThreshold(), other.lockoutThreshold()) && this.hasPermittedNetworks() == other.hasPermittedNetworks() && Objects.equals(this.permittedNetworks(), other.permittedNetworks()) && this.hasPermittedWickrAwsNetworks() == other.hasPermittedWickrAwsNetworks() && Objects.equals(this.permittedWickrAwsNetworks(), other.permittedWickrAwsNetworks()) && this.hasPermittedWickrEnterpriseNetworks() == other.hasPermittedWickrEnterpriseNetworks() && Objects.equals(this.permittedWickrEnterpriseNetworks(), other.permittedWickrEnterpriseNetworks());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityGroupSettings").add("AlwaysReauthenticate", (Object)this.alwaysReauthenticate()).add("AtakPackageValues", this.hasAtakPackageValues() ? this.atakPackageValues() : null).add("Calling", (Object)this.calling()).add("CheckForUpdates", (Object)this.checkForUpdates()).add("EnableAtak", (Object)this.enableAtak()).add("EnableCrashReports", (Object)this.enableCrashReports()).add("EnableFileDownload", (Object)this.enableFileDownload()).add("EnableGuestFederation", (Object)this.enableGuestFederation()).add("EnableNotificationPreview", (Object)this.enableNotificationPreview()).add("EnableOpenAccessOption", (Object)this.enableOpenAccessOption()).add("EnableRestrictedGlobalFederation", (Object)this.enableRestrictedGlobalFederation()).add("FilesEnabled", (Object)this.filesEnabled()).add("ForceDeviceLockout", (Object)this.forceDeviceLockout()).add("ForceOpenAccess", (Object)this.forceOpenAccess()).add("ForceReadReceipts", (Object)this.forceReadReceipts()).add("GlobalFederation", (Object)this.globalFederation()).add("IsAtoEnabled", (Object)this.isAtoEnabled()).add("IsLinkPreviewEnabled", (Object)this.isLinkPreviewEnabled()).add("LocationAllowMaps", (Object)this.locationAllowMaps()).add("LocationEnabled", (Object)this.locationEnabled()).add("MaxAutoDownloadSize", (Object)this.maxAutoDownloadSize()).add("MaxBor", (Object)this.maxBor()).add("MaxTtl", (Object)this.maxTtl()).add("MessageForwardingEnabled", (Object)this.messageForwardingEnabled()).add("PasswordRequirements", (Object)this.passwordRequirements()).add("PresenceEnabled", (Object)this.presenceEnabled()).add("QuickResponses", this.hasQuickResponses() ? this.quickResponses() : null).add("ShowMasterRecoveryKey", (Object)this.showMasterRecoveryKey()).add("Shredder", (Object)this.shredder()).add("SsoMaxIdleMinutes", (Object)this.ssoMaxIdleMinutes()).add("FederationMode", (Object)this.federationMode()).add("LockoutThreshold", (Object)this.lockoutThreshold()).add("PermittedNetworks", this.hasPermittedNetworks() ? this.permittedNetworks() : null).add("PermittedWickrAwsNetworks", this.hasPermittedWickrAwsNetworks() ? this.permittedWickrAwsNetworks() : null).add("PermittedWickrEnterpriseNetworks", this.hasPermittedWickrEnterpriseNetworks() ? this.permittedWickrEnterpriseNetworks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alwaysReauthenticate": {
                return Optional.ofNullable(clazz.cast(this.alwaysReauthenticate()));
            }
            case "atakPackageValues": {
                return Optional.ofNullable(clazz.cast(this.atakPackageValues()));
            }
            case "calling": {
                return Optional.ofNullable(clazz.cast(this.calling()));
            }
            case "checkForUpdates": {
                return Optional.ofNullable(clazz.cast(this.checkForUpdates()));
            }
            case "enableAtak": {
                return Optional.ofNullable(clazz.cast(this.enableAtak()));
            }
            case "enableCrashReports": {
                return Optional.ofNullable(clazz.cast(this.enableCrashReports()));
            }
            case "enableFileDownload": {
                return Optional.ofNullable(clazz.cast(this.enableFileDownload()));
            }
            case "enableGuestFederation": {
                return Optional.ofNullable(clazz.cast(this.enableGuestFederation()));
            }
            case "enableNotificationPreview": {
                return Optional.ofNullable(clazz.cast(this.enableNotificationPreview()));
            }
            case "enableOpenAccessOption": {
                return Optional.ofNullable(clazz.cast(this.enableOpenAccessOption()));
            }
            case "enableRestrictedGlobalFederation": {
                return Optional.ofNullable(clazz.cast(this.enableRestrictedGlobalFederation()));
            }
            case "filesEnabled": {
                return Optional.ofNullable(clazz.cast(this.filesEnabled()));
            }
            case "forceDeviceLockout": {
                return Optional.ofNullable(clazz.cast(this.forceDeviceLockout()));
            }
            case "forceOpenAccess": {
                return Optional.ofNullable(clazz.cast(this.forceOpenAccess()));
            }
            case "forceReadReceipts": {
                return Optional.ofNullable(clazz.cast(this.forceReadReceipts()));
            }
            case "globalFederation": {
                return Optional.ofNullable(clazz.cast(this.globalFederation()));
            }
            case "isAtoEnabled": {
                return Optional.ofNullable(clazz.cast(this.isAtoEnabled()));
            }
            case "isLinkPreviewEnabled": {
                return Optional.ofNullable(clazz.cast(this.isLinkPreviewEnabled()));
            }
            case "locationAllowMaps": {
                return Optional.ofNullable(clazz.cast(this.locationAllowMaps()));
            }
            case "locationEnabled": {
                return Optional.ofNullable(clazz.cast(this.locationEnabled()));
            }
            case "maxAutoDownloadSize": {
                return Optional.ofNullable(clazz.cast(this.maxAutoDownloadSize()));
            }
            case "maxBor": {
                return Optional.ofNullable(clazz.cast(this.maxBor()));
            }
            case "maxTtl": {
                return Optional.ofNullable(clazz.cast(this.maxTtl()));
            }
            case "messageForwardingEnabled": {
                return Optional.ofNullable(clazz.cast(this.messageForwardingEnabled()));
            }
            case "passwordRequirements": {
                return Optional.ofNullable(clazz.cast(this.passwordRequirements()));
            }
            case "presenceEnabled": {
                return Optional.ofNullable(clazz.cast(this.presenceEnabled()));
            }
            case "quickResponses": {
                return Optional.ofNullable(clazz.cast(this.quickResponses()));
            }
            case "showMasterRecoveryKey": {
                return Optional.ofNullable(clazz.cast(this.showMasterRecoveryKey()));
            }
            case "shredder": {
                return Optional.ofNullable(clazz.cast(this.shredder()));
            }
            case "ssoMaxIdleMinutes": {
                return Optional.ofNullable(clazz.cast(this.ssoMaxIdleMinutes()));
            }
            case "federationMode": {
                return Optional.ofNullable(clazz.cast(this.federationMode()));
            }
            case "lockoutThreshold": {
                return Optional.ofNullable(clazz.cast(this.lockoutThreshold()));
            }
            case "permittedNetworks": {
                return Optional.ofNullable(clazz.cast(this.permittedNetworks()));
            }
            case "permittedWickrAwsNetworks": {
                return Optional.ofNullable(clazz.cast(this.permittedWickrAwsNetworks()));
            }
            case "permittedWickrEnterpriseNetworks": {
                return Optional.ofNullable(clazz.cast(this.permittedWickrEnterpriseNetworks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alwaysReauthenticate", ALWAYS_REAUTHENTICATE_FIELD);
        map.put("atakPackageValues", ATAK_PACKAGE_VALUES_FIELD);
        map.put("calling", CALLING_FIELD);
        map.put("checkForUpdates", CHECK_FOR_UPDATES_FIELD);
        map.put("enableAtak", ENABLE_ATAK_FIELD);
        map.put("enableCrashReports", ENABLE_CRASH_REPORTS_FIELD);
        map.put("enableFileDownload", ENABLE_FILE_DOWNLOAD_FIELD);
        map.put("enableGuestFederation", ENABLE_GUEST_FEDERATION_FIELD);
        map.put("enableNotificationPreview", ENABLE_NOTIFICATION_PREVIEW_FIELD);
        map.put("enableOpenAccessOption", ENABLE_OPEN_ACCESS_OPTION_FIELD);
        map.put("enableRestrictedGlobalFederation", ENABLE_RESTRICTED_GLOBAL_FEDERATION_FIELD);
        map.put("filesEnabled", FILES_ENABLED_FIELD);
        map.put("forceDeviceLockout", FORCE_DEVICE_LOCKOUT_FIELD);
        map.put("forceOpenAccess", FORCE_OPEN_ACCESS_FIELD);
        map.put("forceReadReceipts", FORCE_READ_RECEIPTS_FIELD);
        map.put("globalFederation", GLOBAL_FEDERATION_FIELD);
        map.put("isAtoEnabled", IS_ATO_ENABLED_FIELD);
        map.put("isLinkPreviewEnabled", IS_LINK_PREVIEW_ENABLED_FIELD);
        map.put("locationAllowMaps", LOCATION_ALLOW_MAPS_FIELD);
        map.put("locationEnabled", LOCATION_ENABLED_FIELD);
        map.put("maxAutoDownloadSize", MAX_AUTO_DOWNLOAD_SIZE_FIELD);
        map.put("maxBor", MAX_BOR_FIELD);
        map.put("maxTtl", MAX_TTL_FIELD);
        map.put("messageForwardingEnabled", MESSAGE_FORWARDING_ENABLED_FIELD);
        map.put("passwordRequirements", PASSWORD_REQUIREMENTS_FIELD);
        map.put("presenceEnabled", PRESENCE_ENABLED_FIELD);
        map.put("quickResponses", QUICK_RESPONSES_FIELD);
        map.put("showMasterRecoveryKey", SHOW_MASTER_RECOVERY_KEY_FIELD);
        map.put("shredder", SHREDDER_FIELD);
        map.put("ssoMaxIdleMinutes", SSO_MAX_IDLE_MINUTES_FIELD);
        map.put("federationMode", FEDERATION_MODE_FIELD);
        map.put("lockoutThreshold", LOCKOUT_THRESHOLD_FIELD);
        map.put("permittedNetworks", PERMITTED_NETWORKS_FIELD);
        map.put("permittedWickrAwsNetworks", PERMITTED_WICKR_AWS_NETWORKS_FIELD);
        map.put("permittedWickrEnterpriseNetworks", PERMITTED_WICKR_ENTERPRISE_NETWORKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroupSettings, T> g) {
        return obj -> g.apply((SecurityGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean alwaysReauthenticate;
        private List<String> atakPackageValues = DefaultSdkAutoConstructList.getInstance();
        private CallingSettings calling;
        private Boolean checkForUpdates;
        private Boolean enableAtak;
        private Boolean enableCrashReports;
        private Boolean enableFileDownload;
        private Boolean enableGuestFederation;
        private Boolean enableNotificationPreview;
        private Boolean enableOpenAccessOption;
        private Boolean enableRestrictedGlobalFederation;
        private Boolean filesEnabled;
        private Integer forceDeviceLockout;
        private Boolean forceOpenAccess;
        private Boolean forceReadReceipts;
        private Boolean globalFederation;
        private Boolean isAtoEnabled;
        private Boolean isLinkPreviewEnabled;
        private Boolean locationAllowMaps;
        private Boolean locationEnabled;
        private Long maxAutoDownloadSize;
        private Integer maxBor;
        private Long maxTtl;
        private Boolean messageForwardingEnabled;
        private PasswordRequirements passwordRequirements;
        private Boolean presenceEnabled;
        private List<String> quickResponses = DefaultSdkAutoConstructList.getInstance();
        private Boolean showMasterRecoveryKey;
        private ShredderSettings shredder;
        private Integer ssoMaxIdleMinutes;
        private Integer federationMode;
        private Integer lockoutThreshold;
        private List<String> permittedNetworks = DefaultSdkAutoConstructList.getInstance();
        private List<WickrAwsNetworks> permittedWickrAwsNetworks = DefaultSdkAutoConstructList.getInstance();
        private List<PermittedWickrEnterpriseNetwork> permittedWickrEnterpriseNetworks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupSettings model) {
            this.alwaysReauthenticate(model.alwaysReauthenticate);
            this.atakPackageValues(model.atakPackageValues);
            this.calling(model.calling);
            this.checkForUpdates(model.checkForUpdates);
            this.enableAtak(model.enableAtak);
            this.enableCrashReports(model.enableCrashReports);
            this.enableFileDownload(model.enableFileDownload);
            this.enableGuestFederation(model.enableGuestFederation);
            this.enableNotificationPreview(model.enableNotificationPreview);
            this.enableOpenAccessOption(model.enableOpenAccessOption);
            this.enableRestrictedGlobalFederation(model.enableRestrictedGlobalFederation);
            this.filesEnabled(model.filesEnabled);
            this.forceDeviceLockout(model.forceDeviceLockout);
            this.forceOpenAccess(model.forceOpenAccess);
            this.forceReadReceipts(model.forceReadReceipts);
            this.globalFederation(model.globalFederation);
            this.isAtoEnabled(model.isAtoEnabled);
            this.isLinkPreviewEnabled(model.isLinkPreviewEnabled);
            this.locationAllowMaps(model.locationAllowMaps);
            this.locationEnabled(model.locationEnabled);
            this.maxAutoDownloadSize(model.maxAutoDownloadSize);
            this.maxBor(model.maxBor);
            this.maxTtl(model.maxTtl);
            this.messageForwardingEnabled(model.messageForwardingEnabled);
            this.passwordRequirements(model.passwordRequirements);
            this.presenceEnabled(model.presenceEnabled);
            this.quickResponses(model.quickResponses);
            this.showMasterRecoveryKey(model.showMasterRecoveryKey);
            this.shredder(model.shredder);
            this.ssoMaxIdleMinutes(model.ssoMaxIdleMinutes);
            this.federationMode(model.federationMode);
            this.lockoutThreshold(model.lockoutThreshold);
            this.permittedNetworks(model.permittedNetworks);
            this.permittedWickrAwsNetworks(model.permittedWickrAwsNetworks);
            this.permittedWickrEnterpriseNetworks(model.permittedWickrEnterpriseNetworks);
        }

        public final Boolean getAlwaysReauthenticate() {
            return this.alwaysReauthenticate;
        }

        public final void setAlwaysReauthenticate(Boolean alwaysReauthenticate) {
            this.alwaysReauthenticate = alwaysReauthenticate;
        }

        @Override
        public final Builder alwaysReauthenticate(Boolean alwaysReauthenticate) {
            this.alwaysReauthenticate = alwaysReauthenticate;
            return this;
        }

        public final Collection<String> getAtakPackageValues() {
            if (this.atakPackageValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.atakPackageValues;
        }

        public final void setAtakPackageValues(Collection<String> atakPackageValues) {
            this.atakPackageValues = SecurityGroupStringListCopier.copy(atakPackageValues);
        }

        @Override
        public final Builder atakPackageValues(Collection<String> atakPackageValues) {
            this.atakPackageValues = SecurityGroupStringListCopier.copy(atakPackageValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder atakPackageValues(String ... atakPackageValues) {
            this.atakPackageValues(Arrays.asList(atakPackageValues));
            return this;
        }

        public final CallingSettings.Builder getCalling() {
            return this.calling != null ? this.calling.toBuilder() : null;
        }

        public final void setCalling(CallingSettings.BuilderImpl calling) {
            this.calling = calling != null ? calling.build() : null;
        }

        @Override
        public final Builder calling(CallingSettings calling) {
            this.calling = calling;
            return this;
        }

        public final Boolean getCheckForUpdates() {
            return this.checkForUpdates;
        }

        public final void setCheckForUpdates(Boolean checkForUpdates) {
            this.checkForUpdates = checkForUpdates;
        }

        @Override
        public final Builder checkForUpdates(Boolean checkForUpdates) {
            this.checkForUpdates = checkForUpdates;
            return this;
        }

        public final Boolean getEnableAtak() {
            return this.enableAtak;
        }

        public final void setEnableAtak(Boolean enableAtak) {
            this.enableAtak = enableAtak;
        }

        @Override
        public final Builder enableAtak(Boolean enableAtak) {
            this.enableAtak = enableAtak;
            return this;
        }

        public final Boolean getEnableCrashReports() {
            return this.enableCrashReports;
        }

        public final void setEnableCrashReports(Boolean enableCrashReports) {
            this.enableCrashReports = enableCrashReports;
        }

        @Override
        public final Builder enableCrashReports(Boolean enableCrashReports) {
            this.enableCrashReports = enableCrashReports;
            return this;
        }

        public final Boolean getEnableFileDownload() {
            return this.enableFileDownload;
        }

        public final void setEnableFileDownload(Boolean enableFileDownload) {
            this.enableFileDownload = enableFileDownload;
        }

        @Override
        public final Builder enableFileDownload(Boolean enableFileDownload) {
            this.enableFileDownload = enableFileDownload;
            return this;
        }

        public final Boolean getEnableGuestFederation() {
            return this.enableGuestFederation;
        }

        public final void setEnableGuestFederation(Boolean enableGuestFederation) {
            this.enableGuestFederation = enableGuestFederation;
        }

        @Override
        public final Builder enableGuestFederation(Boolean enableGuestFederation) {
            this.enableGuestFederation = enableGuestFederation;
            return this;
        }

        public final Boolean getEnableNotificationPreview() {
            return this.enableNotificationPreview;
        }

        public final void setEnableNotificationPreview(Boolean enableNotificationPreview) {
            this.enableNotificationPreview = enableNotificationPreview;
        }

        @Override
        public final Builder enableNotificationPreview(Boolean enableNotificationPreview) {
            this.enableNotificationPreview = enableNotificationPreview;
            return this;
        }

        public final Boolean getEnableOpenAccessOption() {
            return this.enableOpenAccessOption;
        }

        public final void setEnableOpenAccessOption(Boolean enableOpenAccessOption) {
            this.enableOpenAccessOption = enableOpenAccessOption;
        }

        @Override
        public final Builder enableOpenAccessOption(Boolean enableOpenAccessOption) {
            this.enableOpenAccessOption = enableOpenAccessOption;
            return this;
        }

        public final Boolean getEnableRestrictedGlobalFederation() {
            return this.enableRestrictedGlobalFederation;
        }

        public final void setEnableRestrictedGlobalFederation(Boolean enableRestrictedGlobalFederation) {
            this.enableRestrictedGlobalFederation = enableRestrictedGlobalFederation;
        }

        @Override
        public final Builder enableRestrictedGlobalFederation(Boolean enableRestrictedGlobalFederation) {
            this.enableRestrictedGlobalFederation = enableRestrictedGlobalFederation;
            return this;
        }

        public final Boolean getFilesEnabled() {
            return this.filesEnabled;
        }

        public final void setFilesEnabled(Boolean filesEnabled) {
            this.filesEnabled = filesEnabled;
        }

        @Override
        public final Builder filesEnabled(Boolean filesEnabled) {
            this.filesEnabled = filesEnabled;
            return this;
        }

        public final Integer getForceDeviceLockout() {
            return this.forceDeviceLockout;
        }

        public final void setForceDeviceLockout(Integer forceDeviceLockout) {
            this.forceDeviceLockout = forceDeviceLockout;
        }

        @Override
        public final Builder forceDeviceLockout(Integer forceDeviceLockout) {
            this.forceDeviceLockout = forceDeviceLockout;
            return this;
        }

        public final Boolean getForceOpenAccess() {
            return this.forceOpenAccess;
        }

        public final void setForceOpenAccess(Boolean forceOpenAccess) {
            this.forceOpenAccess = forceOpenAccess;
        }

        @Override
        public final Builder forceOpenAccess(Boolean forceOpenAccess) {
            this.forceOpenAccess = forceOpenAccess;
            return this;
        }

        public final Boolean getForceReadReceipts() {
            return this.forceReadReceipts;
        }

        public final void setForceReadReceipts(Boolean forceReadReceipts) {
            this.forceReadReceipts = forceReadReceipts;
        }

        @Override
        public final Builder forceReadReceipts(Boolean forceReadReceipts) {
            this.forceReadReceipts = forceReadReceipts;
            return this;
        }

        public final Boolean getGlobalFederation() {
            return this.globalFederation;
        }

        public final void setGlobalFederation(Boolean globalFederation) {
            this.globalFederation = globalFederation;
        }

        @Override
        public final Builder globalFederation(Boolean globalFederation) {
            this.globalFederation = globalFederation;
            return this;
        }

        public final Boolean getIsAtoEnabled() {
            return this.isAtoEnabled;
        }

        public final void setIsAtoEnabled(Boolean isAtoEnabled) {
            this.isAtoEnabled = isAtoEnabled;
        }

        @Override
        public final Builder isAtoEnabled(Boolean isAtoEnabled) {
            this.isAtoEnabled = isAtoEnabled;
            return this;
        }

        public final Boolean getIsLinkPreviewEnabled() {
            return this.isLinkPreviewEnabled;
        }

        public final void setIsLinkPreviewEnabled(Boolean isLinkPreviewEnabled) {
            this.isLinkPreviewEnabled = isLinkPreviewEnabled;
        }

        @Override
        public final Builder isLinkPreviewEnabled(Boolean isLinkPreviewEnabled) {
            this.isLinkPreviewEnabled = isLinkPreviewEnabled;
            return this;
        }

        public final Boolean getLocationAllowMaps() {
            return this.locationAllowMaps;
        }

        public final void setLocationAllowMaps(Boolean locationAllowMaps) {
            this.locationAllowMaps = locationAllowMaps;
        }

        @Override
        public final Builder locationAllowMaps(Boolean locationAllowMaps) {
            this.locationAllowMaps = locationAllowMaps;
            return this;
        }

        public final Boolean getLocationEnabled() {
            return this.locationEnabled;
        }

        public final void setLocationEnabled(Boolean locationEnabled) {
            this.locationEnabled = locationEnabled;
        }

        @Override
        public final Builder locationEnabled(Boolean locationEnabled) {
            this.locationEnabled = locationEnabled;
            return this;
        }

        public final Long getMaxAutoDownloadSize() {
            return this.maxAutoDownloadSize;
        }

        public final void setMaxAutoDownloadSize(Long maxAutoDownloadSize) {
            this.maxAutoDownloadSize = maxAutoDownloadSize;
        }

        @Override
        public final Builder maxAutoDownloadSize(Long maxAutoDownloadSize) {
            this.maxAutoDownloadSize = maxAutoDownloadSize;
            return this;
        }

        public final Integer getMaxBor() {
            return this.maxBor;
        }

        public final void setMaxBor(Integer maxBor) {
            this.maxBor = maxBor;
        }

        @Override
        public final Builder maxBor(Integer maxBor) {
            this.maxBor = maxBor;
            return this;
        }

        public final Long getMaxTtl() {
            return this.maxTtl;
        }

        public final void setMaxTtl(Long maxTtl) {
            this.maxTtl = maxTtl;
        }

        @Override
        public final Builder maxTtl(Long maxTtl) {
            this.maxTtl = maxTtl;
            return this;
        }

        public final Boolean getMessageForwardingEnabled() {
            return this.messageForwardingEnabled;
        }

        public final void setMessageForwardingEnabled(Boolean messageForwardingEnabled) {
            this.messageForwardingEnabled = messageForwardingEnabled;
        }

        @Override
        public final Builder messageForwardingEnabled(Boolean messageForwardingEnabled) {
            this.messageForwardingEnabled = messageForwardingEnabled;
            return this;
        }

        public final PasswordRequirements.Builder getPasswordRequirements() {
            return this.passwordRequirements != null ? this.passwordRequirements.toBuilder() : null;
        }

        public final void setPasswordRequirements(PasswordRequirements.BuilderImpl passwordRequirements) {
            this.passwordRequirements = passwordRequirements != null ? passwordRequirements.build() : null;
        }

        @Override
        public final Builder passwordRequirements(PasswordRequirements passwordRequirements) {
            this.passwordRequirements = passwordRequirements;
            return this;
        }

        public final Boolean getPresenceEnabled() {
            return this.presenceEnabled;
        }

        public final void setPresenceEnabled(Boolean presenceEnabled) {
            this.presenceEnabled = presenceEnabled;
        }

        @Override
        public final Builder presenceEnabled(Boolean presenceEnabled) {
            this.presenceEnabled = presenceEnabled;
            return this;
        }

        public final Collection<String> getQuickResponses() {
            if (this.quickResponses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.quickResponses;
        }

        public final void setQuickResponses(Collection<String> quickResponses) {
            this.quickResponses = SecurityGroupStringListCopier.copy(quickResponses);
        }

        @Override
        public final Builder quickResponses(Collection<String> quickResponses) {
            this.quickResponses = SecurityGroupStringListCopier.copy(quickResponses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickResponses(String ... quickResponses) {
            this.quickResponses(Arrays.asList(quickResponses));
            return this;
        }

        public final Boolean getShowMasterRecoveryKey() {
            return this.showMasterRecoveryKey;
        }

        public final void setShowMasterRecoveryKey(Boolean showMasterRecoveryKey) {
            this.showMasterRecoveryKey = showMasterRecoveryKey;
        }

        @Override
        public final Builder showMasterRecoveryKey(Boolean showMasterRecoveryKey) {
            this.showMasterRecoveryKey = showMasterRecoveryKey;
            return this;
        }

        public final ShredderSettings.Builder getShredder() {
            return this.shredder != null ? this.shredder.toBuilder() : null;
        }

        public final void setShredder(ShredderSettings.BuilderImpl shredder) {
            this.shredder = shredder != null ? shredder.build() : null;
        }

        @Override
        public final Builder shredder(ShredderSettings shredder) {
            this.shredder = shredder;
            return this;
        }

        public final Integer getSsoMaxIdleMinutes() {
            return this.ssoMaxIdleMinutes;
        }

        public final void setSsoMaxIdleMinutes(Integer ssoMaxIdleMinutes) {
            this.ssoMaxIdleMinutes = ssoMaxIdleMinutes;
        }

        @Override
        public final Builder ssoMaxIdleMinutes(Integer ssoMaxIdleMinutes) {
            this.ssoMaxIdleMinutes = ssoMaxIdleMinutes;
            return this;
        }

        public final Integer getFederationMode() {
            return this.federationMode;
        }

        public final void setFederationMode(Integer federationMode) {
            this.federationMode = federationMode;
        }

        @Override
        public final Builder federationMode(Integer federationMode) {
            this.federationMode = federationMode;
            return this;
        }

        public final Integer getLockoutThreshold() {
            return this.lockoutThreshold;
        }

        public final void setLockoutThreshold(Integer lockoutThreshold) {
            this.lockoutThreshold = lockoutThreshold;
        }

        @Override
        public final Builder lockoutThreshold(Integer lockoutThreshold) {
            this.lockoutThreshold = lockoutThreshold;
            return this;
        }

        public final Collection<String> getPermittedNetworks() {
            if (this.permittedNetworks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permittedNetworks;
        }

        public final void setPermittedNetworks(Collection<String> permittedNetworks) {
            this.permittedNetworks = PermittedNetworksListCopier.copy(permittedNetworks);
        }

        @Override
        public final Builder permittedNetworks(Collection<String> permittedNetworks) {
            this.permittedNetworks = PermittedNetworksListCopier.copy(permittedNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permittedNetworks(String ... permittedNetworks) {
            this.permittedNetworks(Arrays.asList(permittedNetworks));
            return this;
        }

        public final List<WickrAwsNetworks.Builder> getPermittedWickrAwsNetworks() {
            List<WickrAwsNetworks.Builder> result = WickrAwsNetworksListCopier.copyToBuilder(this.permittedWickrAwsNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermittedWickrAwsNetworks(Collection<WickrAwsNetworks.BuilderImpl> permittedWickrAwsNetworks) {
            this.permittedWickrAwsNetworks = WickrAwsNetworksListCopier.copyFromBuilder(permittedWickrAwsNetworks);
        }

        @Override
        public final Builder permittedWickrAwsNetworks(Collection<WickrAwsNetworks> permittedWickrAwsNetworks) {
            this.permittedWickrAwsNetworks = WickrAwsNetworksListCopier.copy(permittedWickrAwsNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permittedWickrAwsNetworks(WickrAwsNetworks ... permittedWickrAwsNetworks) {
            this.permittedWickrAwsNetworks(Arrays.asList(permittedWickrAwsNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permittedWickrAwsNetworks(Consumer<WickrAwsNetworks.Builder> ... permittedWickrAwsNetworks) {
            this.permittedWickrAwsNetworks(Stream.of(permittedWickrAwsNetworks).map(c -> (WickrAwsNetworks)((WickrAwsNetworks.Builder)WickrAwsNetworks.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PermittedWickrEnterpriseNetwork.Builder> getPermittedWickrEnterpriseNetworks() {
            List<PermittedWickrEnterpriseNetwork.Builder> result = PermittedWickrEnterpriseNetworksListCopier.copyToBuilder(this.permittedWickrEnterpriseNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermittedWickrEnterpriseNetworks(Collection<PermittedWickrEnterpriseNetwork.BuilderImpl> permittedWickrEnterpriseNetworks) {
            this.permittedWickrEnterpriseNetworks = PermittedWickrEnterpriseNetworksListCopier.copyFromBuilder(permittedWickrEnterpriseNetworks);
        }

        @Override
        public final Builder permittedWickrEnterpriseNetworks(Collection<PermittedWickrEnterpriseNetwork> permittedWickrEnterpriseNetworks) {
            this.permittedWickrEnterpriseNetworks = PermittedWickrEnterpriseNetworksListCopier.copy(permittedWickrEnterpriseNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permittedWickrEnterpriseNetworks(PermittedWickrEnterpriseNetwork ... permittedWickrEnterpriseNetworks) {
            this.permittedWickrEnterpriseNetworks(Arrays.asList(permittedWickrEnterpriseNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permittedWickrEnterpriseNetworks(Consumer<PermittedWickrEnterpriseNetwork.Builder> ... permittedWickrEnterpriseNetworks) {
            this.permittedWickrEnterpriseNetworks(Stream.of(permittedWickrEnterpriseNetworks).map(c -> (PermittedWickrEnterpriseNetwork)((PermittedWickrEnterpriseNetwork.Builder)PermittedWickrEnterpriseNetwork.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SecurityGroupSettings build() {
            return new SecurityGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityGroupSettings> {
        public Builder alwaysReauthenticate(Boolean var1);

        public Builder atakPackageValues(Collection<String> var1);

        public Builder atakPackageValues(String ... var1);

        public Builder calling(CallingSettings var1);

        default public Builder calling(Consumer<CallingSettings.Builder> calling) {
            return this.calling((CallingSettings)((CallingSettings.Builder)CallingSettings.builder().applyMutation(calling)).build());
        }

        public Builder checkForUpdates(Boolean var1);

        public Builder enableAtak(Boolean var1);

        public Builder enableCrashReports(Boolean var1);

        public Builder enableFileDownload(Boolean var1);

        public Builder enableGuestFederation(Boolean var1);

        public Builder enableNotificationPreview(Boolean var1);

        public Builder enableOpenAccessOption(Boolean var1);

        public Builder enableRestrictedGlobalFederation(Boolean var1);

        public Builder filesEnabled(Boolean var1);

        public Builder forceDeviceLockout(Integer var1);

        public Builder forceOpenAccess(Boolean var1);

        public Builder forceReadReceipts(Boolean var1);

        public Builder globalFederation(Boolean var1);

        public Builder isAtoEnabled(Boolean var1);

        public Builder isLinkPreviewEnabled(Boolean var1);

        public Builder locationAllowMaps(Boolean var1);

        public Builder locationEnabled(Boolean var1);

        public Builder maxAutoDownloadSize(Long var1);

        public Builder maxBor(Integer var1);

        public Builder maxTtl(Long var1);

        public Builder messageForwardingEnabled(Boolean var1);

        public Builder passwordRequirements(PasswordRequirements var1);

        default public Builder passwordRequirements(Consumer<PasswordRequirements.Builder> passwordRequirements) {
            return this.passwordRequirements((PasswordRequirements)((PasswordRequirements.Builder)PasswordRequirements.builder().applyMutation(passwordRequirements)).build());
        }

        public Builder presenceEnabled(Boolean var1);

        public Builder quickResponses(Collection<String> var1);

        public Builder quickResponses(String ... var1);

        public Builder showMasterRecoveryKey(Boolean var1);

        public Builder shredder(ShredderSettings var1);

        default public Builder shredder(Consumer<ShredderSettings.Builder> shredder) {
            return this.shredder((ShredderSettings)((ShredderSettings.Builder)ShredderSettings.builder().applyMutation(shredder)).build());
        }

        public Builder ssoMaxIdleMinutes(Integer var1);

        public Builder federationMode(Integer var1);

        public Builder lockoutThreshold(Integer var1);

        public Builder permittedNetworks(Collection<String> var1);

        public Builder permittedNetworks(String ... var1);

        public Builder permittedWickrAwsNetworks(Collection<WickrAwsNetworks> var1);

        public Builder permittedWickrAwsNetworks(WickrAwsNetworks ... var1);

        public Builder permittedWickrAwsNetworks(Consumer<WickrAwsNetworks.Builder> ... var1);

        public Builder permittedWickrEnterpriseNetworks(Collection<PermittedWickrEnterpriseNetwork> var1);

        public Builder permittedWickrEnterpriseNetworks(PermittedWickrEnterpriseNetwork ... var1);

        public Builder permittedWickrEnterpriseNetworks(Consumer<PermittedWickrEnterpriseNetwork.Builder> ... var1);
    }
}

