/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.wickr.WickrAsyncClient;
import software.amazon.awssdk.services.wickr.WickrServiceClientConfiguration;
import software.amazon.awssdk.services.wickr.internal.WickrServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.wickr.model.BadRequestErrorException;
import software.amazon.awssdk.services.wickr.model.BatchCreateUserRequest;
import software.amazon.awssdk.services.wickr.model.BatchCreateUserResponse;
import software.amazon.awssdk.services.wickr.model.BatchDeleteUserRequest;
import software.amazon.awssdk.services.wickr.model.BatchDeleteUserResponse;
import software.amazon.awssdk.services.wickr.model.BatchLookupUserUnameRequest;
import software.amazon.awssdk.services.wickr.model.BatchLookupUserUnameResponse;
import software.amazon.awssdk.services.wickr.model.BatchReinviteUserRequest;
import software.amazon.awssdk.services.wickr.model.BatchReinviteUserResponse;
import software.amazon.awssdk.services.wickr.model.BatchResetDevicesForUserRequest;
import software.amazon.awssdk.services.wickr.model.BatchResetDevicesForUserResponse;
import software.amazon.awssdk.services.wickr.model.BatchToggleUserSuspendStatusRequest;
import software.amazon.awssdk.services.wickr.model.BatchToggleUserSuspendStatusResponse;
import software.amazon.awssdk.services.wickr.model.CreateBotRequest;
import software.amazon.awssdk.services.wickr.model.CreateBotResponse;
import software.amazon.awssdk.services.wickr.model.CreateDataRetentionBotChallengeRequest;
import software.amazon.awssdk.services.wickr.model.CreateDataRetentionBotChallengeResponse;
import software.amazon.awssdk.services.wickr.model.CreateDataRetentionBotRequest;
import software.amazon.awssdk.services.wickr.model.CreateDataRetentionBotResponse;
import software.amazon.awssdk.services.wickr.model.CreateNetworkRequest;
import software.amazon.awssdk.services.wickr.model.CreateNetworkResponse;
import software.amazon.awssdk.services.wickr.model.CreateSecurityGroupRequest;
import software.amazon.awssdk.services.wickr.model.CreateSecurityGroupResponse;
import software.amazon.awssdk.services.wickr.model.DeleteBotRequest;
import software.amazon.awssdk.services.wickr.model.DeleteBotResponse;
import software.amazon.awssdk.services.wickr.model.DeleteDataRetentionBotRequest;
import software.amazon.awssdk.services.wickr.model.DeleteDataRetentionBotResponse;
import software.amazon.awssdk.services.wickr.model.DeleteNetworkRequest;
import software.amazon.awssdk.services.wickr.model.DeleteNetworkResponse;
import software.amazon.awssdk.services.wickr.model.DeleteSecurityGroupRequest;
import software.amazon.awssdk.services.wickr.model.DeleteSecurityGroupResponse;
import software.amazon.awssdk.services.wickr.model.ForbiddenErrorException;
import software.amazon.awssdk.services.wickr.model.GetBotRequest;
import software.amazon.awssdk.services.wickr.model.GetBotResponse;
import software.amazon.awssdk.services.wickr.model.GetBotsCountRequest;
import software.amazon.awssdk.services.wickr.model.GetBotsCountResponse;
import software.amazon.awssdk.services.wickr.model.GetDataRetentionBotRequest;
import software.amazon.awssdk.services.wickr.model.GetDataRetentionBotResponse;
import software.amazon.awssdk.services.wickr.model.GetGuestUserHistoryCountRequest;
import software.amazon.awssdk.services.wickr.model.GetGuestUserHistoryCountResponse;
import software.amazon.awssdk.services.wickr.model.GetNetworkRequest;
import software.amazon.awssdk.services.wickr.model.GetNetworkResponse;
import software.amazon.awssdk.services.wickr.model.GetNetworkSettingsRequest;
import software.amazon.awssdk.services.wickr.model.GetNetworkSettingsResponse;
import software.amazon.awssdk.services.wickr.model.GetOidcInfoRequest;
import software.amazon.awssdk.services.wickr.model.GetOidcInfoResponse;
import software.amazon.awssdk.services.wickr.model.GetSecurityGroupRequest;
import software.amazon.awssdk.services.wickr.model.GetSecurityGroupResponse;
import software.amazon.awssdk.services.wickr.model.GetUserRequest;
import software.amazon.awssdk.services.wickr.model.GetUserResponse;
import software.amazon.awssdk.services.wickr.model.GetUsersCountRequest;
import software.amazon.awssdk.services.wickr.model.GetUsersCountResponse;
import software.amazon.awssdk.services.wickr.model.InternalServerErrorException;
import software.amazon.awssdk.services.wickr.model.ListBlockedGuestUsersRequest;
import software.amazon.awssdk.services.wickr.model.ListBlockedGuestUsersResponse;
import software.amazon.awssdk.services.wickr.model.ListBotsRequest;
import software.amazon.awssdk.services.wickr.model.ListBotsResponse;
import software.amazon.awssdk.services.wickr.model.ListDevicesForUserRequest;
import software.amazon.awssdk.services.wickr.model.ListDevicesForUserResponse;
import software.amazon.awssdk.services.wickr.model.ListGuestUsersRequest;
import software.amazon.awssdk.services.wickr.model.ListGuestUsersResponse;
import software.amazon.awssdk.services.wickr.model.ListNetworksRequest;
import software.amazon.awssdk.services.wickr.model.ListNetworksResponse;
import software.amazon.awssdk.services.wickr.model.ListSecurityGroupUsersRequest;
import software.amazon.awssdk.services.wickr.model.ListSecurityGroupUsersResponse;
import software.amazon.awssdk.services.wickr.model.ListSecurityGroupsRequest;
import software.amazon.awssdk.services.wickr.model.ListSecurityGroupsResponse;
import software.amazon.awssdk.services.wickr.model.ListUsersRequest;
import software.amazon.awssdk.services.wickr.model.ListUsersResponse;
import software.amazon.awssdk.services.wickr.model.RateLimitErrorException;
import software.amazon.awssdk.services.wickr.model.RegisterOidcConfigRequest;
import software.amazon.awssdk.services.wickr.model.RegisterOidcConfigResponse;
import software.amazon.awssdk.services.wickr.model.RegisterOidcConfigTestRequest;
import software.amazon.awssdk.services.wickr.model.RegisterOidcConfigTestResponse;
import software.amazon.awssdk.services.wickr.model.ResourceNotFoundErrorException;
import software.amazon.awssdk.services.wickr.model.UnauthorizedErrorException;
import software.amazon.awssdk.services.wickr.model.UpdateBotRequest;
import software.amazon.awssdk.services.wickr.model.UpdateBotResponse;
import software.amazon.awssdk.services.wickr.model.UpdateDataRetentionRequest;
import software.amazon.awssdk.services.wickr.model.UpdateDataRetentionResponse;
import software.amazon.awssdk.services.wickr.model.UpdateGuestUserRequest;
import software.amazon.awssdk.services.wickr.model.UpdateGuestUserResponse;
import software.amazon.awssdk.services.wickr.model.UpdateNetworkRequest;
import software.amazon.awssdk.services.wickr.model.UpdateNetworkResponse;
import software.amazon.awssdk.services.wickr.model.UpdateNetworkSettingsRequest;
import software.amazon.awssdk.services.wickr.model.UpdateNetworkSettingsResponse;
import software.amazon.awssdk.services.wickr.model.UpdateSecurityGroupRequest;
import software.amazon.awssdk.services.wickr.model.UpdateSecurityGroupResponse;
import software.amazon.awssdk.services.wickr.model.UpdateUserRequest;
import software.amazon.awssdk.services.wickr.model.UpdateUserResponse;
import software.amazon.awssdk.services.wickr.model.ValidationErrorException;
import software.amazon.awssdk.services.wickr.model.WickrException;
import software.amazon.awssdk.services.wickr.transform.BatchCreateUserRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.BatchDeleteUserRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.BatchLookupUserUnameRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.BatchReinviteUserRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.BatchResetDevicesForUserRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.BatchToggleUserSuspendStatusRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.CreateBotRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.CreateDataRetentionBotChallengeRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.CreateDataRetentionBotRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.CreateNetworkRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.CreateSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.DeleteBotRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.DeleteDataRetentionBotRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.DeleteNetworkRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.DeleteSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetBotRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetBotsCountRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetDataRetentionBotRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetGuestUserHistoryCountRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetNetworkRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetOidcInfoRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetUserRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetUsersCountRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.ListBlockedGuestUsersRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.ListBotsRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.ListDevicesForUserRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.ListGuestUsersRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.ListNetworksRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.ListSecurityGroupUsersRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.ListSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.RegisterOidcConfigRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.RegisterOidcConfigTestRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.UpdateBotRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.UpdateDataRetentionRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.UpdateGuestUserRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.UpdateNetworkRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.UpdateNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.UpdateSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultWickrAsyncClient
implements WickrAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultWickrAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWickrAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Wickr#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<BatchCreateUserResponse> batchCreateUser(BatchCreateUserRequest batchCreateUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchCreateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, batchCreateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchCreateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchCreateUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchCreateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchCreateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchCreateUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$batchCreateUser$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$batchCreateUser$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDeleteUserResponse> batchDeleteUser(BatchDeleteUserRequest batchDeleteUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDeleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, batchDeleteUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchDeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDeleteUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$batchDeleteUser$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$batchDeleteUser$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchLookupUserUnameResponse> batchLookupUserUname(BatchLookupUserUnameRequest batchLookupUserUnameRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchLookupUserUnameRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, batchLookupUserUnameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchLookupUserUname");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchLookupUserUnameResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchLookupUserUname").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchLookupUserUnameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchLookupUserUnameRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$batchLookupUserUname$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$batchLookupUserUname$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchReinviteUserResponse> batchReinviteUser(BatchReinviteUserRequest batchReinviteUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchReinviteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, batchReinviteUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchReinviteUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchReinviteUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchReinviteUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchReinviteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchReinviteUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$batchReinviteUser$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$batchReinviteUser$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchResetDevicesForUserResponse> batchResetDevicesForUser(BatchResetDevicesForUserRequest batchResetDevicesForUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchResetDevicesForUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, batchResetDevicesForUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchResetDevicesForUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchResetDevicesForUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchResetDevicesForUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchResetDevicesForUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchResetDevicesForUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$batchResetDevicesForUser$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$batchResetDevicesForUser$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchToggleUserSuspendStatusResponse> batchToggleUserSuspendStatus(BatchToggleUserSuspendStatusRequest batchToggleUserSuspendStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchToggleUserSuspendStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, batchToggleUserSuspendStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchToggleUserSuspendStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchToggleUserSuspendStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchToggleUserSuspendStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchToggleUserSuspendStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchToggleUserSuspendStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$batchToggleUserSuspendStatus$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$batchToggleUserSuspendStatus$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateBotResponse> createBot(CreateBotRequest createBotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, createBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createBotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$createBot$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$createBot$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDataRetentionBotResponse> createDataRetentionBot(CreateDataRetentionBotRequest createDataRetentionBotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDataRetentionBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, createDataRetentionBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataRetentionBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataRetentionBotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataRetentionBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDataRetentionBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDataRetentionBotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$createDataRetentionBot$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$createDataRetentionBot$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDataRetentionBotChallengeResponse> createDataRetentionBotChallenge(CreateDataRetentionBotChallengeRequest createDataRetentionBotChallengeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDataRetentionBotChallengeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, createDataRetentionBotChallengeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataRetentionBotChallenge");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataRetentionBotChallengeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataRetentionBotChallenge").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDataRetentionBotChallengeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDataRetentionBotChallengeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$createDataRetentionBotChallenge$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$createDataRetentionBotChallenge$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateNetworkResponse> createNetwork(CreateNetworkRequest createNetworkRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, createNetworkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateNetwork");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNetworkResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNetwork").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createNetworkRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$createNetwork$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$createNetwork$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSecurityGroupResponse> createSecurityGroup(CreateSecurityGroupRequest createSecurityGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSecurityGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, createSecurityGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSecurityGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSecurityGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSecurityGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSecurityGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSecurityGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$createSecurityGroup$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$createSecurityGroup$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBotResponse> deleteBot(DeleteBotRequest deleteBotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, deleteBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteBotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$deleteBot$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$deleteBot$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDataRetentionBotResponse> deleteDataRetentionBot(DeleteDataRetentionBotRequest deleteDataRetentionBotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDataRetentionBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDataRetentionBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataRetentionBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataRetentionBotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataRetentionBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDataRetentionBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDataRetentionBotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$deleteDataRetentionBot$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$deleteDataRetentionBot$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteNetworkResponse> deleteNetwork(DeleteNetworkRequest deleteNetworkRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, deleteNetworkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNetwork");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNetworkResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNetwork").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteNetworkRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$deleteNetwork$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$deleteNetwork$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSecurityGroupResponse> deleteSecurityGroup(DeleteSecurityGroupRequest deleteSecurityGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSecurityGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSecurityGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSecurityGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSecurityGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSecurityGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSecurityGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSecurityGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$deleteSecurityGroup$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$deleteSecurityGroup$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBotResponse> getBot(GetBotRequest getBotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, getBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$getBot$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$getBot$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBotsCountResponse> getBotsCount(GetBotsCountRequest getBotsCountRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBotsCountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, getBotsCountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBotsCount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBotsCountResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBotsCount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetBotsCountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBotsCountRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$getBotsCount$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$getBotsCount$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDataRetentionBotResponse> getDataRetentionBot(GetDataRetentionBotRequest getDataRetentionBotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDataRetentionBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, getDataRetentionBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataRetentionBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataRetentionBotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataRetentionBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDataRetentionBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDataRetentionBotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$getDataRetentionBot$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$getDataRetentionBot$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetGuestUserHistoryCountResponse> getGuestUserHistoryCount(GetGuestUserHistoryCountRequest getGuestUserHistoryCountRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getGuestUserHistoryCountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, getGuestUserHistoryCountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGuestUserHistoryCount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGuestUserHistoryCountResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGuestUserHistoryCount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetGuestUserHistoryCountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getGuestUserHistoryCountRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$getGuestUserHistoryCount$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$getGuestUserHistoryCount$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetNetworkResponse> getNetwork(GetNetworkRequest getNetworkRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, getNetworkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetNetwork");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNetworkResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNetwork").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getNetworkRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$getNetwork$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$getNetwork$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetNetworkSettingsResponse> getNetworkSettings(GetNetworkSettingsRequest getNetworkSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getNetworkSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, getNetworkSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetNetworkSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNetworkSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNetworkSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetNetworkSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getNetworkSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$getNetworkSettings$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$getNetworkSettings$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetOidcInfoResponse> getOidcInfo(GetOidcInfoRequest getOidcInfoRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOidcInfoRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, getOidcInfoRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOidcInfo");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOidcInfoResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOidcInfo").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetOidcInfoRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getOidcInfoRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$getOidcInfo$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$getOidcInfo$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSecurityGroupResponse> getSecurityGroup(GetSecurityGroupRequest getSecurityGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSecurityGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, getSecurityGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSecurityGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSecurityGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSecurityGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSecurityGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSecurityGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$getSecurityGroup$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$getSecurityGroup$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetUserResponse> getUser(GetUserRequest getUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, getUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$getUser$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$getUser$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetUsersCountResponse> getUsersCount(GetUsersCountRequest getUsersCountRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getUsersCountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, getUsersCountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUsersCount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUsersCountResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUsersCount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetUsersCountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getUsersCountRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$getUsersCount$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$getUsersCount$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListBlockedGuestUsersResponse> listBlockedGuestUsers(ListBlockedGuestUsersRequest listBlockedGuestUsersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBlockedGuestUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, listBlockedGuestUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBlockedGuestUsers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBlockedGuestUsersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBlockedGuestUsers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListBlockedGuestUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listBlockedGuestUsersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$listBlockedGuestUsers$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$listBlockedGuestUsers$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListBotsResponse> listBots(ListBotsRequest listBotsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, listBotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBotsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListBotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listBotsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$listBots$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$listBots$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDevicesForUserResponse> listDevicesForUser(ListDevicesForUserRequest listDevicesForUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDevicesForUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, listDevicesForUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDevicesForUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevicesForUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevicesForUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDevicesForUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDevicesForUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$listDevicesForUser$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$listDevicesForUser$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListGuestUsersResponse> listGuestUsers(ListGuestUsersRequest listGuestUsersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGuestUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, listGuestUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGuestUsers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGuestUsersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGuestUsers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListGuestUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listGuestUsersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$listGuestUsers$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$listGuestUsers$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListNetworksResponse> listNetworks(ListNetworksRequest listNetworksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listNetworksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, listNetworksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNetworks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNetworksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNetworks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListNetworksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listNetworksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$listNetworks$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$listNetworks$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSecurityGroupUsersResponse> listSecurityGroupUsers(ListSecurityGroupUsersRequest listSecurityGroupUsersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSecurityGroupUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, listSecurityGroupUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSecurityGroupUsers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSecurityGroupUsersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSecurityGroupUsers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListSecurityGroupUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listSecurityGroupUsersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$listSecurityGroupUsers$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$listSecurityGroupUsers$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSecurityGroupsResponse> listSecurityGroups(ListSecurityGroupsRequest listSecurityGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSecurityGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, listSecurityGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSecurityGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSecurityGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSecurityGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListSecurityGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listSecurityGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$listSecurityGroups$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$listSecurityGroups$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, listUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUsers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listUsersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$listUsers$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$listUsers$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterOidcConfigResponse> registerOidcConfig(RegisterOidcConfigRequest registerOidcConfigRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerOidcConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, registerOidcConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterOidcConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterOidcConfigResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterOidcConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterOidcConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerOidcConfigRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$registerOidcConfig$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$registerOidcConfig$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterOidcConfigTestResponse> registerOidcConfigTest(RegisterOidcConfigTestRequest registerOidcConfigTestRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerOidcConfigTestRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, registerOidcConfigTestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterOidcConfigTest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterOidcConfigTestResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterOidcConfigTest").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterOidcConfigTestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerOidcConfigTestRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$registerOidcConfigTest$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$registerOidcConfigTest$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateBotResponse> updateBot(UpdateBotRequest updateBotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, updateBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateBotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$updateBot$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$updateBot$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDataRetentionResponse> updateDataRetention(UpdateDataRetentionRequest updateDataRetentionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDataRetentionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, updateDataRetentionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataRetention");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataRetentionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataRetention").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateDataRetentionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDataRetentionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$updateDataRetention$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$updateDataRetention$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateGuestUserResponse> updateGuestUser(UpdateGuestUserRequest updateGuestUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateGuestUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, updateGuestUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGuestUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGuestUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGuestUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateGuestUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateGuestUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$updateGuestUser$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$updateGuestUser$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateNetworkResponse> updateNetwork(UpdateNetworkRequest updateNetworkRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, updateNetworkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNetwork");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNetworkResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNetwork").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateNetworkRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$updateNetwork$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$updateNetwork$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateNetworkSettingsResponse> updateNetworkSettings(UpdateNetworkSettingsRequest updateNetworkSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateNetworkSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, updateNetworkSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNetworkSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNetworkSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNetworkSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateNetworkSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateNetworkSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$updateNetworkSettings$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$updateNetworkSettings$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSecurityGroupResponse> updateSecurityGroup(UpdateSecurityGroupRequest updateSecurityGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSecurityGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, updateSecurityGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSecurityGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSecurityGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSecurityGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSecurityGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSecurityGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$updateSecurityGroup$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$updateSecurityGroup$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrAsyncClient.resolveMetricPublishers(clientConfiguration, updateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RateLimitError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                    }
                    case "ResourceNotFoundError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                    }
                    case "ValidationError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                    }
                    case "BadRequestError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                    }
                    case "UnauthorizedError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                    }
                    case "ForbiddenError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWickrAsyncClient.lambda$updateUser$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWickrAsyncClient.lambda$updateUser$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final WickrServiceClientConfiguration serviceClientConfiguration() {
        return new WickrServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "wickr";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(WickrException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        WickrServiceClientConfigurationBuilder serviceConfigBuilder = new WickrServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateUser$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateUser$166(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSecurityGroup$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSecurityGroup$162(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSecurityGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateNetworkSettings$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateNetworkSettings$158(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateNetworkSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateNetwork$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateNetwork$154(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateNetworkResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateGuestUser$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGuestUser$150(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateGuestUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDataRetention$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDataRetention$146(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDataRetentionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateBot$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBot$142(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateBotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerOidcConfigTest$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerOidcConfigTest$138(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterOidcConfigTestResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerOidcConfig$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerOidcConfig$134(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterOidcConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listUsers$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUsers$130(List metricPublishers, MetricCollector apiCallMetricCollector, ListUsersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listSecurityGroups$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSecurityGroups$126(List metricPublishers, MetricCollector apiCallMetricCollector, ListSecurityGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listSecurityGroupUsers$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSecurityGroupUsers$122(List metricPublishers, MetricCollector apiCallMetricCollector, ListSecurityGroupUsersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listNetworks$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNetworks$118(List metricPublishers, MetricCollector apiCallMetricCollector, ListNetworksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listGuestUsers$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGuestUsers$114(List metricPublishers, MetricCollector apiCallMetricCollector, ListGuestUsersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDevicesForUser$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDevicesForUser$110(List metricPublishers, MetricCollector apiCallMetricCollector, ListDevicesForUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listBots$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBots$106(List metricPublishers, MetricCollector apiCallMetricCollector, ListBotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listBlockedGuestUsers$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBlockedGuestUsers$102(List metricPublishers, MetricCollector apiCallMetricCollector, ListBlockedGuestUsersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getUsersCount$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUsersCount$98(List metricPublishers, MetricCollector apiCallMetricCollector, GetUsersCountResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getUser$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUser$94(List metricPublishers, MetricCollector apiCallMetricCollector, GetUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSecurityGroup$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSecurityGroup$90(List metricPublishers, MetricCollector apiCallMetricCollector, GetSecurityGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getOidcInfo$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOidcInfo$86(List metricPublishers, MetricCollector apiCallMetricCollector, GetOidcInfoResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getNetworkSettings$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getNetworkSettings$82(List metricPublishers, MetricCollector apiCallMetricCollector, GetNetworkSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getNetwork$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getNetwork$78(List metricPublishers, MetricCollector apiCallMetricCollector, GetNetworkResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getGuestUserHistoryCount$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGuestUserHistoryCount$74(List metricPublishers, MetricCollector apiCallMetricCollector, GetGuestUserHistoryCountResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDataRetentionBot$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataRetentionBot$70(List metricPublishers, MetricCollector apiCallMetricCollector, GetDataRetentionBotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBotsCount$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBotsCount$66(List metricPublishers, MetricCollector apiCallMetricCollector, GetBotsCountResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBot$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBot$62(List metricPublishers, MetricCollector apiCallMetricCollector, GetBotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSecurityGroup$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSecurityGroup$58(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSecurityGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteNetwork$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteNetwork$54(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteNetworkResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDataRetentionBot$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataRetentionBot$50(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDataRetentionBotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBot$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBot$46(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSecurityGroup$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSecurityGroup$42(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSecurityGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createNetwork$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createNetwork$38(List metricPublishers, MetricCollector apiCallMetricCollector, CreateNetworkResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDataRetentionBotChallenge$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataRetentionBotChallenge$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDataRetentionBotChallengeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDataRetentionBot$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataRetentionBot$30(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDataRetentionBotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createBot$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBot$26(List metricPublishers, MetricCollector apiCallMetricCollector, CreateBotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchToggleUserSuspendStatus$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchToggleUserSuspendStatus$22(List metricPublishers, MetricCollector apiCallMetricCollector, BatchToggleUserSuspendStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchResetDevicesForUser$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchResetDevicesForUser$18(List metricPublishers, MetricCollector apiCallMetricCollector, BatchResetDevicesForUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchReinviteUser$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchReinviteUser$14(List metricPublishers, MetricCollector apiCallMetricCollector, BatchReinviteUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchLookupUserUname$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchLookupUserUname$10(List metricPublishers, MetricCollector apiCallMetricCollector, BatchLookupUserUnameResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDeleteUser$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteUser$6(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDeleteUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchCreateUser$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchCreateUser$2(List metricPublishers, MetricCollector apiCallMetricCollector, BatchCreateUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

