/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.wickr.WickrClient;
import software.amazon.awssdk.services.wickr.WickrServiceClientConfiguration;
import software.amazon.awssdk.services.wickr.internal.WickrServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.wickr.model.BadRequestErrorException;
import software.amazon.awssdk.services.wickr.model.BatchCreateUserRequest;
import software.amazon.awssdk.services.wickr.model.BatchCreateUserResponse;
import software.amazon.awssdk.services.wickr.model.BatchDeleteUserRequest;
import software.amazon.awssdk.services.wickr.model.BatchDeleteUserResponse;
import software.amazon.awssdk.services.wickr.model.BatchLookupUserUnameRequest;
import software.amazon.awssdk.services.wickr.model.BatchLookupUserUnameResponse;
import software.amazon.awssdk.services.wickr.model.BatchReinviteUserRequest;
import software.amazon.awssdk.services.wickr.model.BatchReinviteUserResponse;
import software.amazon.awssdk.services.wickr.model.BatchResetDevicesForUserRequest;
import software.amazon.awssdk.services.wickr.model.BatchResetDevicesForUserResponse;
import software.amazon.awssdk.services.wickr.model.BatchToggleUserSuspendStatusRequest;
import software.amazon.awssdk.services.wickr.model.BatchToggleUserSuspendStatusResponse;
import software.amazon.awssdk.services.wickr.model.CreateBotRequest;
import software.amazon.awssdk.services.wickr.model.CreateBotResponse;
import software.amazon.awssdk.services.wickr.model.CreateDataRetentionBotChallengeRequest;
import software.amazon.awssdk.services.wickr.model.CreateDataRetentionBotChallengeResponse;
import software.amazon.awssdk.services.wickr.model.CreateDataRetentionBotRequest;
import software.amazon.awssdk.services.wickr.model.CreateDataRetentionBotResponse;
import software.amazon.awssdk.services.wickr.model.CreateNetworkRequest;
import software.amazon.awssdk.services.wickr.model.CreateNetworkResponse;
import software.amazon.awssdk.services.wickr.model.CreateSecurityGroupRequest;
import software.amazon.awssdk.services.wickr.model.CreateSecurityGroupResponse;
import software.amazon.awssdk.services.wickr.model.DeleteBotRequest;
import software.amazon.awssdk.services.wickr.model.DeleteBotResponse;
import software.amazon.awssdk.services.wickr.model.DeleteDataRetentionBotRequest;
import software.amazon.awssdk.services.wickr.model.DeleteDataRetentionBotResponse;
import software.amazon.awssdk.services.wickr.model.DeleteNetworkRequest;
import software.amazon.awssdk.services.wickr.model.DeleteNetworkResponse;
import software.amazon.awssdk.services.wickr.model.DeleteSecurityGroupRequest;
import software.amazon.awssdk.services.wickr.model.DeleteSecurityGroupResponse;
import software.amazon.awssdk.services.wickr.model.ForbiddenErrorException;
import software.amazon.awssdk.services.wickr.model.GetBotRequest;
import software.amazon.awssdk.services.wickr.model.GetBotResponse;
import software.amazon.awssdk.services.wickr.model.GetBotsCountRequest;
import software.amazon.awssdk.services.wickr.model.GetBotsCountResponse;
import software.amazon.awssdk.services.wickr.model.GetDataRetentionBotRequest;
import software.amazon.awssdk.services.wickr.model.GetDataRetentionBotResponse;
import software.amazon.awssdk.services.wickr.model.GetGuestUserHistoryCountRequest;
import software.amazon.awssdk.services.wickr.model.GetGuestUserHistoryCountResponse;
import software.amazon.awssdk.services.wickr.model.GetNetworkRequest;
import software.amazon.awssdk.services.wickr.model.GetNetworkResponse;
import software.amazon.awssdk.services.wickr.model.GetNetworkSettingsRequest;
import software.amazon.awssdk.services.wickr.model.GetNetworkSettingsResponse;
import software.amazon.awssdk.services.wickr.model.GetOidcInfoRequest;
import software.amazon.awssdk.services.wickr.model.GetOidcInfoResponse;
import software.amazon.awssdk.services.wickr.model.GetSecurityGroupRequest;
import software.amazon.awssdk.services.wickr.model.GetSecurityGroupResponse;
import software.amazon.awssdk.services.wickr.model.GetUserRequest;
import software.amazon.awssdk.services.wickr.model.GetUserResponse;
import software.amazon.awssdk.services.wickr.model.GetUsersCountRequest;
import software.amazon.awssdk.services.wickr.model.GetUsersCountResponse;
import software.amazon.awssdk.services.wickr.model.InternalServerErrorException;
import software.amazon.awssdk.services.wickr.model.ListBlockedGuestUsersRequest;
import software.amazon.awssdk.services.wickr.model.ListBlockedGuestUsersResponse;
import software.amazon.awssdk.services.wickr.model.ListBotsRequest;
import software.amazon.awssdk.services.wickr.model.ListBotsResponse;
import software.amazon.awssdk.services.wickr.model.ListDevicesForUserRequest;
import software.amazon.awssdk.services.wickr.model.ListDevicesForUserResponse;
import software.amazon.awssdk.services.wickr.model.ListGuestUsersRequest;
import software.amazon.awssdk.services.wickr.model.ListGuestUsersResponse;
import software.amazon.awssdk.services.wickr.model.ListNetworksRequest;
import software.amazon.awssdk.services.wickr.model.ListNetworksResponse;
import software.amazon.awssdk.services.wickr.model.ListSecurityGroupUsersRequest;
import software.amazon.awssdk.services.wickr.model.ListSecurityGroupUsersResponse;
import software.amazon.awssdk.services.wickr.model.ListSecurityGroupsRequest;
import software.amazon.awssdk.services.wickr.model.ListSecurityGroupsResponse;
import software.amazon.awssdk.services.wickr.model.ListUsersRequest;
import software.amazon.awssdk.services.wickr.model.ListUsersResponse;
import software.amazon.awssdk.services.wickr.model.RateLimitErrorException;
import software.amazon.awssdk.services.wickr.model.RegisterOidcConfigRequest;
import software.amazon.awssdk.services.wickr.model.RegisterOidcConfigResponse;
import software.amazon.awssdk.services.wickr.model.RegisterOidcConfigTestRequest;
import software.amazon.awssdk.services.wickr.model.RegisterOidcConfigTestResponse;
import software.amazon.awssdk.services.wickr.model.ResourceNotFoundErrorException;
import software.amazon.awssdk.services.wickr.model.UnauthorizedErrorException;
import software.amazon.awssdk.services.wickr.model.UpdateBotRequest;
import software.amazon.awssdk.services.wickr.model.UpdateBotResponse;
import software.amazon.awssdk.services.wickr.model.UpdateDataRetentionRequest;
import software.amazon.awssdk.services.wickr.model.UpdateDataRetentionResponse;
import software.amazon.awssdk.services.wickr.model.UpdateGuestUserRequest;
import software.amazon.awssdk.services.wickr.model.UpdateGuestUserResponse;
import software.amazon.awssdk.services.wickr.model.UpdateNetworkRequest;
import software.amazon.awssdk.services.wickr.model.UpdateNetworkResponse;
import software.amazon.awssdk.services.wickr.model.UpdateNetworkSettingsRequest;
import software.amazon.awssdk.services.wickr.model.UpdateNetworkSettingsResponse;
import software.amazon.awssdk.services.wickr.model.UpdateSecurityGroupRequest;
import software.amazon.awssdk.services.wickr.model.UpdateSecurityGroupResponse;
import software.amazon.awssdk.services.wickr.model.UpdateUserRequest;
import software.amazon.awssdk.services.wickr.model.UpdateUserResponse;
import software.amazon.awssdk.services.wickr.model.ValidationErrorException;
import software.amazon.awssdk.services.wickr.model.WickrException;
import software.amazon.awssdk.services.wickr.transform.BatchCreateUserRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.BatchDeleteUserRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.BatchLookupUserUnameRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.BatchReinviteUserRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.BatchResetDevicesForUserRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.BatchToggleUserSuspendStatusRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.CreateBotRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.CreateDataRetentionBotChallengeRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.CreateDataRetentionBotRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.CreateNetworkRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.CreateSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.DeleteBotRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.DeleteDataRetentionBotRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.DeleteNetworkRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.DeleteSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetBotRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetBotsCountRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetDataRetentionBotRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetGuestUserHistoryCountRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetNetworkRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetOidcInfoRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetUserRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.GetUsersCountRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.ListBlockedGuestUsersRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.ListBotsRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.ListDevicesForUserRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.ListGuestUsersRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.ListNetworksRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.ListSecurityGroupUsersRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.ListSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.RegisterOidcConfigRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.RegisterOidcConfigTestRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.UpdateBotRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.UpdateDataRetentionRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.UpdateGuestUserRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.UpdateNetworkRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.UpdateNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.UpdateSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.wickr.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultWickrClient
implements WickrClient {
    private static final Logger log = Logger.loggerFor(DefaultWickrClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWickrClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Wickr#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchCreateUserResponse batchCreateUser(BatchCreateUserRequest batchCreateUserRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchCreateUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchCreateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, batchCreateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchCreateUser");
            BatchCreateUserResponse batchCreateUserResponse = (BatchCreateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchCreateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchCreateUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchCreateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchCreateUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$batchCreateUser$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteUserResponse batchDeleteUser(BatchDeleteUserRequest batchDeleteUserRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDeleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, batchDeleteUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteUser");
            BatchDeleteUserResponse batchDeleteUserResponse = (BatchDeleteUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDeleteUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDeleteUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$batchDeleteUser$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchLookupUserUnameResponse batchLookupUserUname(BatchLookupUserUnameRequest batchLookupUserUnameRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchLookupUserUnameResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchLookupUserUnameRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, batchLookupUserUnameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchLookupUserUname");
            BatchLookupUserUnameResponse batchLookupUserUnameResponse = (BatchLookupUserUnameResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchLookupUserUname").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchLookupUserUnameRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchLookupUserUnameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchLookupUserUnameResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$batchLookupUserUname$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchReinviteUserResponse batchReinviteUser(BatchReinviteUserRequest batchReinviteUserRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchReinviteUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchReinviteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, batchReinviteUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchReinviteUser");
            BatchReinviteUserResponse batchReinviteUserResponse = (BatchReinviteUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchReinviteUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchReinviteUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchReinviteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchReinviteUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$batchReinviteUser$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchResetDevicesForUserResponse batchResetDevicesForUser(BatchResetDevicesForUserRequest batchResetDevicesForUserRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchResetDevicesForUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchResetDevicesForUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, batchResetDevicesForUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchResetDevicesForUser");
            BatchResetDevicesForUserResponse batchResetDevicesForUserResponse = (BatchResetDevicesForUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchResetDevicesForUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchResetDevicesForUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchResetDevicesForUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchResetDevicesForUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$batchResetDevicesForUser$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchToggleUserSuspendStatusResponse batchToggleUserSuspendStatus(BatchToggleUserSuspendStatusRequest batchToggleUserSuspendStatusRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchToggleUserSuspendStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchToggleUserSuspendStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, batchToggleUserSuspendStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchToggleUserSuspendStatus");
            BatchToggleUserSuspendStatusResponse batchToggleUserSuspendStatusResponse = (BatchToggleUserSuspendStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchToggleUserSuspendStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchToggleUserSuspendStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchToggleUserSuspendStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchToggleUserSuspendStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$batchToggleUserSuspendStatus$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBotResponse createBot(CreateBotRequest createBotRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, createBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBot");
            CreateBotResponse createBotResponse = (CreateBotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$createBot$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataRetentionBotResponse createDataRetentionBot(CreateDataRetentionBotRequest createDataRetentionBotRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataRetentionBotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDataRetentionBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, createDataRetentionBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataRetentionBot");
            CreateDataRetentionBotResponse createDataRetentionBotResponse = (CreateDataRetentionBotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataRetentionBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDataRetentionBotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataRetentionBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataRetentionBotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$createDataRetentionBot$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataRetentionBotChallengeResponse createDataRetentionBotChallenge(CreateDataRetentionBotChallengeRequest createDataRetentionBotChallengeRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataRetentionBotChallengeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDataRetentionBotChallengeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, createDataRetentionBotChallengeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataRetentionBotChallenge");
            CreateDataRetentionBotChallengeResponse createDataRetentionBotChallengeResponse = (CreateDataRetentionBotChallengeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataRetentionBotChallenge").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDataRetentionBotChallengeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataRetentionBotChallengeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataRetentionBotChallengeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$createDataRetentionBotChallenge$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateNetworkResponse createNetwork(CreateNetworkRequest createNetworkRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNetworkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, createNetworkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateNetwork");
            CreateNetworkResponse createNetworkResponse = (CreateNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNetwork").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createNetworkRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createNetworkResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$createNetwork$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSecurityGroupResponse createSecurityGroup(CreateSecurityGroupRequest createSecurityGroupRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSecurityGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSecurityGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, createSecurityGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSecurityGroup");
            CreateSecurityGroupResponse createSecurityGroupResponse = (CreateSecurityGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSecurityGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createSecurityGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSecurityGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSecurityGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$createSecurityGroup$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBotResponse deleteBot(DeleteBotRequest deleteBotRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, deleteBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBot");
            DeleteBotResponse deleteBotResponse = (DeleteBotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$deleteBot$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataRetentionBotResponse deleteDataRetentionBot(DeleteDataRetentionBotRequest deleteDataRetentionBotRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataRetentionBotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDataRetentionBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, deleteDataRetentionBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataRetentionBot");
            DeleteDataRetentionBotResponse deleteDataRetentionBotResponse = (DeleteDataRetentionBotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataRetentionBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDataRetentionBotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDataRetentionBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDataRetentionBotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$deleteDataRetentionBot$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteNetworkResponse deleteNetwork(DeleteNetworkRequest deleteNetworkRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNetworkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, deleteNetworkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNetwork");
            DeleteNetworkResponse deleteNetworkResponse = (DeleteNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNetwork").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteNetworkRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteNetworkResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$deleteNetwork$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSecurityGroupResponse deleteSecurityGroup(DeleteSecurityGroupRequest deleteSecurityGroupRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSecurityGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSecurityGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, deleteSecurityGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSecurityGroup");
            DeleteSecurityGroupResponse deleteSecurityGroupResponse = (DeleteSecurityGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSecurityGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSecurityGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSecurityGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSecurityGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$deleteSecurityGroup$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBotResponse getBot(GetBotRequest getBotRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, getBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBot");
            GetBotResponse getBotResponse = (GetBotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$getBot$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBotsCountResponse getBotsCount(GetBotsCountRequest getBotsCountRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBotsCountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBotsCountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, getBotsCountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBotsCount");
            GetBotsCountResponse getBotsCountResponse = (GetBotsCountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBotsCount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBotsCountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBotsCountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBotsCountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$getBotsCount$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataRetentionBotResponse getDataRetentionBot(GetDataRetentionBotRequest getDataRetentionBotRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataRetentionBotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDataRetentionBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, getDataRetentionBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataRetentionBot");
            GetDataRetentionBotResponse getDataRetentionBotResponse = (GetDataRetentionBotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataRetentionBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDataRetentionBotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDataRetentionBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDataRetentionBotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$getDataRetentionBot$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGuestUserHistoryCountResponse getGuestUserHistoryCount(GetGuestUserHistoryCountRequest getGuestUserHistoryCountRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGuestUserHistoryCountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getGuestUserHistoryCountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, getGuestUserHistoryCountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGuestUserHistoryCount");
            GetGuestUserHistoryCountResponse getGuestUserHistoryCountResponse = (GetGuestUserHistoryCountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGuestUserHistoryCount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getGuestUserHistoryCountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGuestUserHistoryCountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGuestUserHistoryCountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$getGuestUserHistoryCount$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetNetworkResponse getNetwork(GetNetworkRequest getNetworkRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNetworkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, getNetworkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetNetwork");
            GetNetworkResponse getNetworkResponse = (GetNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNetwork").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getNetworkRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getNetworkResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$getNetwork$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetNetworkSettingsResponse getNetworkSettings(GetNetworkSettingsRequest getNetworkSettingsRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNetworkSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getNetworkSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, getNetworkSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetNetworkSettings");
            GetNetworkSettingsResponse getNetworkSettingsResponse = (GetNetworkSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNetworkSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getNetworkSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetNetworkSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getNetworkSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$getNetworkSettings$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOidcInfoResponse getOidcInfo(GetOidcInfoRequest getOidcInfoRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOidcInfoResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOidcInfoRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, getOidcInfoRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOidcInfo");
            GetOidcInfoResponse getOidcInfoResponse = (GetOidcInfoResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOidcInfo").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getOidcInfoRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetOidcInfoRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getOidcInfoResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$getOidcInfo$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSecurityGroupResponse getSecurityGroup(GetSecurityGroupRequest getSecurityGroupRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSecurityGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSecurityGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, getSecurityGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSecurityGroup");
            GetSecurityGroupResponse getSecurityGroupResponse = (GetSecurityGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSecurityGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSecurityGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSecurityGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSecurityGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$getSecurityGroup$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUserResponse getUser(GetUserRequest getUserRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, getUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUser");
            GetUserResponse getUserResponse = (GetUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$getUser$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUsersCountResponse getUsersCount(GetUsersCountRequest getUsersCountRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUsersCountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getUsersCountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, getUsersCountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUsersCount");
            GetUsersCountResponse getUsersCountResponse = (GetUsersCountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUsersCount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getUsersCountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetUsersCountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUsersCountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$getUsersCount$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBlockedGuestUsersResponse listBlockedGuestUsers(ListBlockedGuestUsersRequest listBlockedGuestUsersRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBlockedGuestUsersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBlockedGuestUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, listBlockedGuestUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBlockedGuestUsers");
            ListBlockedGuestUsersResponse listBlockedGuestUsersResponse = (ListBlockedGuestUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBlockedGuestUsers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listBlockedGuestUsersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBlockedGuestUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBlockedGuestUsersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$listBlockedGuestUsers$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBotsResponse listBots(ListBotsRequest listBotsRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBotsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, listBotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBots");
            ListBotsResponse listBotsResponse = (ListBotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listBotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$listBots$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDevicesForUserResponse listDevicesForUser(ListDevicesForUserRequest listDevicesForUserRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevicesForUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDevicesForUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, listDevicesForUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDevicesForUser");
            ListDevicesForUserResponse listDevicesForUserResponse = (ListDevicesForUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevicesForUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDevicesForUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDevicesForUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDevicesForUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$listDevicesForUser$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGuestUsersResponse listGuestUsers(ListGuestUsersRequest listGuestUsersRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGuestUsersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGuestUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, listGuestUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGuestUsers");
            ListGuestUsersResponse listGuestUsersResponse = (ListGuestUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGuestUsers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listGuestUsersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGuestUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGuestUsersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$listGuestUsers$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNetworksResponse listNetworks(ListNetworksRequest listNetworksRequest) throws ValidationErrorException, BadRequestErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNetworksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listNetworksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, listNetworksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNetworks");
            ListNetworksResponse listNetworksResponse = (ListNetworksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNetworks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listNetworksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListNetworksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNetworksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$listNetworks$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSecurityGroupUsersResponse listSecurityGroupUsers(ListSecurityGroupUsersRequest listSecurityGroupUsersRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSecurityGroupUsersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSecurityGroupUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, listSecurityGroupUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSecurityGroupUsers");
            ListSecurityGroupUsersResponse listSecurityGroupUsersResponse = (ListSecurityGroupUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSecurityGroupUsers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSecurityGroupUsersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSecurityGroupUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSecurityGroupUsersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$listSecurityGroupUsers$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSecurityGroupsResponse listSecurityGroups(ListSecurityGroupsRequest listSecurityGroupsRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSecurityGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSecurityGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, listSecurityGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSecurityGroups");
            ListSecurityGroupsResponse listSecurityGroupsResponse = (ListSecurityGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSecurityGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSecurityGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSecurityGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSecurityGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$listSecurityGroups$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, listUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUsers");
            ListUsersResponse listUsersResponse = (ListUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listUsersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listUsersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$listUsers$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterOidcConfigResponse registerOidcConfig(RegisterOidcConfigRequest registerOidcConfigRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterOidcConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerOidcConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, registerOidcConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterOidcConfig");
            RegisterOidcConfigResponse registerOidcConfigResponse = (RegisterOidcConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterOidcConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerOidcConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterOidcConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerOidcConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$registerOidcConfig$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterOidcConfigTestResponse registerOidcConfigTest(RegisterOidcConfigTestRequest registerOidcConfigTestRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterOidcConfigTestResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerOidcConfigTestRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, registerOidcConfigTestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterOidcConfigTest");
            RegisterOidcConfigTestResponse registerOidcConfigTestResponse = (RegisterOidcConfigTestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterOidcConfigTest").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerOidcConfigTestRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterOidcConfigTestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerOidcConfigTestResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$registerOidcConfigTest$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBotResponse updateBot(UpdateBotRequest updateBotRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, updateBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBot");
            UpdateBotResponse updateBotResponse = (UpdateBotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateBotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$updateBot$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDataRetentionResponse updateDataRetention(UpdateDataRetentionRequest updateDataRetentionRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataRetentionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDataRetentionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, updateDataRetentionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataRetention");
            UpdateDataRetentionResponse updateDataRetentionResponse = (UpdateDataRetentionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataRetention").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDataRetentionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDataRetentionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDataRetentionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$updateDataRetention$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGuestUserResponse updateGuestUser(UpdateGuestUserRequest updateGuestUserRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGuestUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateGuestUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, updateGuestUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGuestUser");
            UpdateGuestUserResponse updateGuestUserResponse = (UpdateGuestUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGuestUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateGuestUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGuestUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGuestUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$updateGuestUser$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNetworkResponse updateNetwork(UpdateNetworkRequest updateNetworkRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNetworkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, updateNetworkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNetwork");
            UpdateNetworkResponse updateNetworkResponse = (UpdateNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNetwork").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateNetworkRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateNetworkResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$updateNetwork$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNetworkSettingsResponse updateNetworkSettings(UpdateNetworkSettingsRequest updateNetworkSettingsRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNetworkSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateNetworkSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, updateNetworkSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNetworkSettings");
            UpdateNetworkSettingsResponse updateNetworkSettingsResponse = (UpdateNetworkSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNetworkSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateNetworkSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateNetworkSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateNetworkSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$updateNetworkSettings$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSecurityGroupResponse updateSecurityGroup(UpdateSecurityGroupRequest updateSecurityGroupRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSecurityGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSecurityGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, updateSecurityGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSecurityGroup");
            UpdateSecurityGroupResponse updateSecurityGroupResponse = (UpdateSecurityGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSecurityGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateSecurityGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSecurityGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSecurityGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$updateSecurityGroup$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws ValidationErrorException, BadRequestErrorException, ResourceNotFoundErrorException, ForbiddenErrorException, UnauthorizedErrorException, InternalServerErrorException, RateLimitErrorException, AwsServiceException, SdkClientException, WickrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RateLimitError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitError").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(RateLimitErrorException::builder).build());
                }
                case "ResourceNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundErrorException::builder).build());
                }
                case "ValidationError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationError").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(ValidationErrorException::builder).build());
                }
                case "BadRequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestErrorException::builder).build());
                }
                case "UnauthorizedError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedError").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedErrorException::builder).build());
                }
                case "ForbiddenError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenError").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenErrorException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWickrClient.resolveMetricPublishers(clientConfiguration, updateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Wickr");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUser");
            UpdateUserResponse updateUserResponse = (UpdateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWickrClient.lambda$updateUser$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "wickr";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        WickrServiceClientConfigurationBuilder serviceConfigBuilder = new WickrServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(WickrException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final WickrServiceClientConfiguration serviceClientConfiguration() {
        return new WickrServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateUser$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSecurityGroup$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateNetworkSettings$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateNetwork$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGuestUser$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDataRetention$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBot$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerOidcConfigTest$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerOidcConfig$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUsers$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSecurityGroups$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSecurityGroupUsers$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNetworks$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGuestUsers$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDevicesForUser$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBots$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBlockedGuestUsers$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUsersCount$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUser$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSecurityGroup$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOidcInfo$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getNetworkSettings$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getNetwork$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGuestUserHistoryCount$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataRetentionBot$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBotsCount$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBot$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSecurityGroup$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteNetwork$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataRetentionBot$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBot$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSecurityGroup$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createNetwork$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataRetentionBotChallenge$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataRetentionBot$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBot$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchToggleUserSuspendStatus$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchResetDevicesForUser$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchReinviteUser$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchLookupUserUname$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteUser$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchCreateUser$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

